#!/bin/sh
#
###########################################
# Create Scripts
###########################################
cd bin

# Creating uninstall script...

# echo "if [ -f /etc/pbeagent.pid ]" > uninstall
# echo "then" >> uninstall
# echo "/etc/rc.d/init.d/PBEAgent stop" >> uninstall
# echo "fi" >> uninstall

# using echo puts a newline at the end.  
# using printf does not put newline.  
# each is used where necessary

cat > startup <<\End-of-startup
#!/bin/sh
#
# Startup/ Shutdown script for PowerChute Serial Shutdown Agent.
#
# Linux chkconfig stuff:
# chkconfig: 2345 99 99
#
### BEGIN INIT INFO 
# Provides: PBEAgent 
# Required-Start: 
# Required-Stop: 
# Should-Start: 
# Should-Stop: 
# Default-Start: 3 5 
# Default-Stop: 
# Short-Description: PBE Agent 
# Description: PowerChute Serial Shutdown Agent Deamon 
### END INIT INFO 

# Return values acc. to LSB for all commands but status:
# 0 - success
# 1 - generic or unspecified error
# 2 - invalid or excess argument(s)
# 3 - unimplemented feature (e.g. "reload")
# 4 - insufficient privilege
# 5 - program is not installed
# 6 - program is not configured
# 7 - program is not running
# 
# Note that starting an already running service, stopping
# or restarting a not-running service as well as the restart
# with force-reload (in case signalling is not supported) are
# considered a success.

# PCSS Agent Service Startup Locale
End-of-startup

if [[ $LANG = ja* ]]; then
    echo "export LC_ALL=ja_JP.UTF-8" >> startup
elif [[ $LC_CTYPE = ja* ]]; then
    echo "export LC_ALL=ja_JP.UTF-8" >> startup
elif [[ $LANG = POSIX ]] || [[ -z $LANG ]]; then
    if [[ `grep LANG /etc/sysconfig/i18n` = "LANG=\"ja*" ]]; then
        echo "export LC_ALL=ja_JP.UTF-8" >> startup
    fi 2>/dev/null
fi

cat >> startup <<\End-of-startup

check () {
    # Check that we're a privileged user
    [ `id -u` = 0 ] || exit 4
}

start () {
    check
    runlevel | grep 1 > /dev/null
    if [ $? = 0 ]
    then

		if [[ $LANG = en* ]]; then
			echo "Can not start in runlevel 1"
		elif [[ $LANG = ja* ]]; then
			echo "ランレベル1で開始できません"
		elif [[ $LANG = zh* ]]; then
			echo "无法在运行级别 1 中启动"
		fi

        return 1
    fi
    
    ps `cat /etc/pbeagent.pid 2>/dev/null | awk "{ print "'$1'" }"` | grep Dpicard.main.thread > /dev/null
    if [ $? = 0 -a -e /etc/pbeagent.pid ]
    then

		if [[ $LANG = en* ]]; then
			echo "Process Already Running."
		elif [[ $LANG = ja* ]]; then
			echo "すでに実行中です。"
		elif [[ $LANG = zh* ]]; then
			echo "已在运行中。"
		fi

        return 0
    else
End-of-startup

cat >> startup <<End-of-startup

        JAVA_RUNTIME=$RPM_INSTALL_PREFIX/../jre/bin/java 

        cd $RPM_INSTALL_PREFIX
        export LD_LIBRARY_PATH=\$LD_LIBRARY_PATH:$RPM_INSTALL_PREFIX/lib/linux64
        
        \$JAVA_RUNTIME -Dpicard.main.thread=blocking -Djava.io.tmpdir=temp -Dfile.encoding=UTF-8 -classpath "lib/*:Resources/*:comp/*" com.apcc.m11.application.PicardApplication 2>/dev/null 1>/dev/null &
		
End-of-startup

cat >> startup <<\End-of-startup
        echo $! >/etc/pbeagent.pid
        touch /var/lock/subsys/PBEAgent 1>/dev/null 2>/dev/null
        return 0
    fi
}

stop () {
    check
    PID=`cat /etc/pbeagent.pid 2>/dev/null | awk "{ print "'$1'" }"`
    kill $PID 1>/dev/null 2>/dev/null
    rm -f /etc/pbeagent.pid 1>/dev/null 2>/dev/null
    rm -f /var/lock/subsys/PBEAgent 1>/dev/null 2>/dev/null
    return 0
}

status () {
    ps `cat /etc/pbeagent.pid 2>/dev/null | awk "{ print "'$1'" }"` | grep Dpicard.main.thread > /dev/null
    if [ $? = 0 -a -e /etc/pbeagent.pid ]
    then

		if [[ $LANG = en* ]]; then
			echo "Running."
		elif [[ $LANG = ja* ]]; then
			echo "実行中。"
		elif [[ $LANG = zh* ]]; then
			echo "运行中。"
		fi

        RETVAL=0
    else

		if [[ $LANG = en* ]]; then
			echo "Stopped."
		elif [[ $LANG = ja* ]]; then
			echo "停止。"
		elif [[ $LANG = zh* ]]; then
			echo "已停止。"
		fi

        RETVAL=3
    fi
    return $RETVAL
}

restart () {
    stop
    start
}


RETVAL=0
case $1 in
    start)
        start
        RETVAL=$?
        ;;
    stop)
        stop
        RETVAL=$?
        ;;
    status)
        status
        RETVAL=$?
        ;;
    restart)
        restart
        RETVAL=$?
        ;;
    *)
        echo "Usage $0 {start|stop|restart|status}"
        RETVAL=2
esac

exit $RETVAL

End-of-startup

cd ..

# Creating config.sh script...

cat >> config.sh <<\End-of-config
#!/bin/sh
# config.sh for PCSS rpm install ver 1.1.0
# Configures PCSS 1.1.0

# Warn on SIGHUP, SIGINT, SIGQUIT and SIGTERM
trap TrapHandler HUP INT QUIT TERM

TrapHandler() {
	# Called when the script is interrupted

	echo ""

	if [[ $LANG = en* ]]; then
		echo " ##### User Abort Detected! #####"
		echo "PowerChute may not operate correctly until configuration has completed successfully."
	elif [[ $LANG = ja* ]]; then
		echo " ##### ユーザーによる停止を検出! #####"
		echo "構成が正常に完了しないと、PowerChuteが正しく作動しない場合があります。"
	elif [[ $LANG = zh* ]]; then
		echo " ##### 检测到用户中止！ #####"
		echo "配置未完成，则 PowerChute 无法正确运行。"
	fi

	exit 1
}

AddESXiTargetServer() {
    if [ -f /etc/vima-release ] || [ -f /etc/vma-release ]; then
        echo " "
		
		if [[ $LANG = en* ]]; then
			echo "In order for PowerChute to shutdown the ESXi host, it must be added as a target server."
		elif [[ $LANG = ja* ]]; then
			echo "PowerChuteを使用してESXiホストをシャットダウンするには、ターゲットサーバーとして追加する必要があります。"
		elif [[ $LANG = zh* ]]; then
			echo "如需 PowerChute 关闭 ESXi 主机，其必须添加为目标服务器。"
		fi
        
        # validIP:
        # 0 - IP is valid
        # 1 - IP is invalid
        # 2 - User is skipping this
        
        validIP=1
                
        while [ $validIP -eq 1 ]
        do

			if [[ $LANG = en* ]]; then
				echo "Please enter ESXi host IP (XXX.XXX.XXX.XXX) or (q) to skip:"
			elif [[ $LANG = ja* ]]; then
				echo "ESXiホストIP (XXX.XXX.XXX.XXX)を入力するか、(q)でスキップしてください。"
			elif [[ $LANG = zh* ]]; then
				echo "请输入 ESXi 主机 IP (XXX.XXX.XXX.XXX) 或者 (q) 以跳过："
			fi

            read esxihostip
        
            case $esxihostip in
                [qQ])
                    validIP=2
                    printf "\nSkipping configuration of ESXi Host Shutdown.\n"
                    ;;
            esac
            
            
            if [ $validIP -ne 2 ]; then
                #
                # Validate IP
                #
                valid_ip $esxihostip
                if [ $? -ne 0 ]; then
                    # invalid ip
                    printf "\nInvalid IP entered.\n"
                    validIP=1
                else
                    # Check that the ip is not already added.
                    vifp listservers | grep $esxihostip > /dev/null 2>&1
                    if [ $? -eq 0 ]; then
                        validIP=2

						if [[ $LANG = en* ]]; then
							echo "ESXi host IP is already on the target server list."
						elif [[ $LANG = ja* ]]; then
							echo "ESXiホストIPはすでにターゲットサーバーリストにあります。"
						elif [[ $LANG = zh* ]]; then
							echo "ESXi 主机 IP 已在目标服务器列表中。"
						fi

                    else
                        validIP=0
                    fi
                fi                
            fi            
        done
        
        if [ $validIP -eq 0 ]; then

			if [[ $LANG = en* ]]; then
				echo "Please enter ESXi host username:"
			elif [[ $LANG = ja* ]]; then
				echo "ESXiホストのユーザー名を入力："
			elif [[ $LANG = zh* ]]; then
				echo "请输入 ESXi 主机用户名："
			fi

            read esxihostuser
        
			if [[ $LANG = en* ]]; then
				echo "Please enter ESXi host password:"
			elif [[ $LANG = ja* ]]; then
				echo "ESXiホストのパスワード："
			elif [[ $LANG = zh* ]]; then
				echo "请输入 ESXi 主机密码："
			fi

            OLDCONFIG=`stty -g`
            stty -icanon -echo min 1 time 0
            read esxihostpwd
            stty $OLDCONFIG
        
			if [[ $LANG = en* ]]; then
				echo "Adding target server..."
			elif [[ $LANG = ja* ]]; then
				echo "ターゲットサーバーの追加..."
			elif [[ $LANG = zh* ]]; then
				echo "正添加目标服务器..."
			fi
            
            vifp addserver $esxihostip --username $esxihostuser --password $esxihostpwd
            vifp listservers | grep $esxihostip
            if [ $? -eq 0 ]; then

					if [[ $LANG = en* ]]; then
						echo "Successfully added ESXi host to target server list."
					elif [[ $LANG = ja* ]]; then
						echo "ESXiホストがターゲットサーバーリストに正常に追加されました。"
					elif [[ $LANG = zh* ]]; then
						echo "已成功将 ESXi 主机添加至目标服务器列表。"
					fi
					
					echo ""
            else

					if [[ $LANG = en* ]]; then
						echo "Failed to add ESXi host."
						echo "To add the host manually please run - sudo vifp addserver <ipaddress>"
					elif [[ $LANG = ja* ]]; then
						echo "ESXiホストの追加に失敗しました。"
						echo "ホストを手動で追加するには、「sudo vifp addserver <ipaddress>」を実行してください。"
					elif [[ $LANG = zh* ]]; then
						echo "添加 ESXi 主机失败。"
						echo "如需手工添加主机，请执行命令：sudo vifp addserver <ipaddress>"
					fi

					echo ""
            fi        
        fi        
    fi
}

valid_ip()
{
    ERROR=0
    oldIFS=$IFS
    IFS=.
    set -f
    set -- $1
    if [ $# -eq 4 ]; then
        for seg
        do
            case $seg in
                ""|*[!0-9]*) ERROR=1;break ;; ## Segment empty or non-numeric char
                *) [ $seg -gt 255 ] && ERROR=2 ;;
            esac
        done
    else
        ERROR=3 ## Not 4 segments
    fi
    IFS=$oldIFS
    set +f
    return $ERROR
}
End-of-config

echo "if [ -z \$1 ]" >> config.sh
echo "then clear" >> config.sh
echo "fi" >> config.sh
echo "# Stop agent if running" >> config.sh
echo "ps \`cat /etc/pbeagent.pid 2>/dev/null | awk \"{ print \"'\$1'\" }\"\` > /dev/null" >> config.sh
echo "if [ \$? = 0 -a -e /etc/pbeagent.pid ]" >> config.sh
echo "then" >> config.sh
echo "PID=\`cat /etc/pbeagent.pid 2>/dev/null | awk \"{ print \"'\$1'\" }\"\`" >> config.sh
echo "kill \$PID 1>/dev/null 2>/dev/null" >> config.sh
echo "rm -f /etc/pbeagent.pid 1>/dev/null 2>/dev/null" >> config.sh
echo "fi" >> config.sh
echo "# Prepare to change parameters" >> config.sh
echo "if [[ "$1" == "x86_64" ]]; then" >> config.sh
echo "cd $RPM_INSTALL_PREFIX/lib/linux64" >> config.sh
echo "else" >> config.sh
echo "cd $RPM_INSTALL_PREFIX/lib/linux" >> config.sh
echo "fi" >> config.sh
echo "if ! [ -L libPocoFoundation.so ]; then " >> config.sh
echo "ln -s libPocoFoundation.so.95 libPocoFoundation.so" >> config.sh
echo "fi" >> config.sh

echo "ERROR=0"  >> config.sh

echo "cd $RPM_INSTALL_PREFIX" >> config.sh
echo "$RPM_INSTALL_PREFIX/../jre/bin/java --add-exports java.base/com.sun.crypto.provider=ALL-UNNAMED -jar ./lib/pcssconfig.jar \$1 \$2 \$3 \$4 \$5" >> config.sh
echo ""  >> config.sh

echo "# pcbe.config.jar returns 1 when arguments we passed in indicating a silent install otherwise 0 is returned" >> config.sh
echo "if [ \$? = 0 ]; then" >> config.sh
echo "    AddESXiTargetServer" >> config.sh
echo "    echo  \"\" "  >> config.sh
echo "    if [[ $LANG = en* ]]; then" >> config.sh
echo "        echo \"Start PowerChute Serial Shutdown Agent? (Yes or No) \" " >> config.sh
echo "        echo -n \"> \" " >> config.sh
echo "    elif [[ $LANG = ja* ]]; then" >> config.sh
echo "        echo \"PowerChute Serial Shutdownエージェントを起動しますか？(Yes or No) \" " >> config.sh
echo "        echo -n \"> \" " >> config.sh
echo "    elif [[ $LANG = zh* ]]; then" >> config.sh
echo "        echo \"是否启动 PowerChute Serial Shutdown 代理？（Yes or No） \" " >> config.sh
echo "        echo -n \"> \" " >> config.sh
echo "    fi" >> config.sh
echo "    read res"  >> config.sh
echo "    case \"\$res\" in"  >> config.sh
echo "    [Yy]*)"  >> config.sh
echo "        if [ -x /usr/bin/systemctl ]; then"  >> config.sh
echo "            systemctl start PBEAgent"  >> config.sh
echo "        else "  >> config.sh
echo "            /etc/init.d/PBEAgent start"  >> config.sh
echo "        fi"  >> config.sh
echo "        echo PowerChute Serial Shutdown started."  >> config.sh
echo "    	  echo  \"\" "  >> config.sh
echo "    	  echo  \"\" "  >> config.sh
echo "        ;;"  >> config.sh
echo "    *)"  >> config.sh
echo "        echo  "  >> config.sh
echo "        ;;"  >> config.sh
echo "    esac"  >> config.sh
echo "else"  >> config.sh
echo "    if [ \$? = 2 ]; then" >> config.sh
echo "        ERROR=1"  >> config.sh
echo "    fi"  >> config.sh
echo "fi"  >> config.sh
echo "exit \$ERROR"  >> config.sh

# Set file permissions
chmod 0540 $RPM_INSTALL_PREFIX/bin/startup
chmod 0540 $RPM_INSTALL_PREFIX/config.sh
