<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<html lang="${localeData.resourcesLocale}">
<c:set var="res" value="${localeData.properties}" />
<c:set var="version" value="?${pcbeSettings.productVersion}"/>

<head>

  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="Expires" content="-1">
  <meta http-equiv="Pragma" content="no-cache">
  <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">

  <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
  <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/jquery.cluetip.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/demo_page.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/demo_table.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/demo_table_jui.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/ColReorder.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/ColVis.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/datalog.min.css${version}">

  <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
  <script type="text/javascript" src="/js/jquery.validate.min.js${version}"></script>
  <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
  <script type="text/javascript" src="/js/common.js${version}"></script>
  <script type="text/javascript" src="/js/jquery.cluetip.js${version}"></script>
  <script type="text/javascript" src="/js/jquery.dataTables.min.js${version}"></script>  
  <script type="text/javascript" src="/js/ColReorder.min.js${version}"></script>  
  <script type="text/javascript" src="/js/FixedColumns.min.js${version}"></script>  
  <script type="text/javascript" src="/js/ColVis.js${version}"></script>  
  <script type="text/javascript" src="/js/datalog.js${version}"></script>
  
  <title>${page.title}</title>
</head>
<body>
  <%@ include file="banner.jspf" %>
  <%@ include file="menu.jspf" %>
  <main id="contentcontainer">
    <h1 id="pageHeader">${page.header}</h1>
    
    <%-- holds error message warning --%>
    <div class="ui-corner-all" id="errorcontainer">
        ${res.ErrorBoxMsg}
    </div>
    
    <form id="formpageform" action="<c:url value='${page.action}'/>" name="${page.name}" method="post">
      <div id="mainbox">

        <%--  Warn the user if data logging is disabled --%>
        <c:if test="${dataLoggingConfigured eq false}">        
        <div class="label-value-pair">
          <div id="dataLoggingConfigure" class="valueEntry">
            <span>
            <div class="value">${res.DataLoggingDisabled}&nbsp;</div>
            <div class="value"><a href="${logsettingsurl}">${res.ClickHereToConfigure}</a></div>
            </span>
          </div>
        </div>
        </c:if>
        
        <br/>
    
        <div>
           <%-- JQuery Datatables will do the work of rendering the table data.
                See datalog.js  --%>
           <table id="datalog" name="datalog" class="table_legenda">
              <thead>
                 <tr>
                    <th>${res.DateHeader}</th>
                    <th>${res.Timestamp}</th>
                    <th>${res.InputLineVoltageTitle}&nbsp;${res.InputLineVoltageUnits}</th>
                    <c:if test="${not isBackUPS}"> 
                    	<th>${res.UPSOutputVoltageTitle}&nbsp;${res.UPSOutputVoltageUnits}</th>
                    </c:if>
                    <th>${res.BatteryVoltageTitle}&nbsp;${res.BatteryVoltageUnits}</th>
                    <th>${res.BatteryCapacityTitle}&nbsp;${res.BatteryCapacityUnits}</th>
                    <c:if test="${not isBackUPS}"> 
                    	<th>${res.InputFrequencyTitle}&nbsp;${res.InputFrequencyUnits}</th>
                    	<th>${res.OutputFrequencyTitle}&nbsp;${res.OutputFrequencyUnits}</th>
                    </c:if>
                    <th>${res.UPSLoadTitle}&nbsp;${res.UPSLoadUnits}</th>
                    <c:if test="${not isBackUPS}"> 
                    	<th>${res.InternalUPSTempTitle}&nbsp;${res.InternalUPSTempUnits}</th>
                    </c:if>
                 </tr>
              </thead>
              <tbody>
              </tbody>
           </table>
        </div>
        
        <br/>
        <br/>
        
        <div id="alertMessageDialog" class="dialog"></div>
        
        <div id="button-bar">
          <input type="submit" value="${res.ButtonClearLog}" class="button" id="clear" name="clear"/>
          <input type="submit" value="${res.ButtonResetColumns}" class="button" id="reset" name="reset"/>
          <input type="button" value="${res.ButtonRefresh}" class="button" id="refresh" name="refresh" onClick="updateTable();"/>
        </div>

      </div> <%-- End of mainbox --%>
      <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}"/>
      <input type="hidden" name="formtokenid" id="formtokenid" value="${formtokenid}"/>
    </form>
  </main><%-- End of container --%>
  <div id="res">
    <span id="resButtonClearLog">${res.ButtonClearLog}</span>
    <span id="resClearDataLogConfirmation">${res.ClearDataLogConfirmation}</span>
    <span id="resDataLoggingDisabled">${res.NoDataLogged}</span>
    <span id="resButtonCancel">${res.ButtonCancel}</span>
    <span id="resButtonOK">${res.ButtonOK}</span>
    <%-- JQuery DataTables Internationalisation/Localisation --%>
    <span id="ressLengthMenu">${res.sLengthMenu}</span>
    <span id="ressZeroRecords">${res.sZeroRecords}</span>
    <span id="ressInfo">${res.sInfo}</span>
    <span id="ressInfoEmpty">${res.sInfoEmpty}</span>
    <span id="ressEmptyTable">${res.sEmptyTable}</span>
    <span id="ressLoadingRecords">${res.sLoadingRecords}</span>
    <span id="ressProcessing">${res.sProcessing}</span>
    <span id="ressFirst">${res.sFirst}</span>
    <span id="ressLast">${res.sLast}</span>
    <span id="ressNext">${res.sNext}</span>
    <span id="ressPrevious">${res.sPrevious}</span>
    <span id="ressShowHideColumns">${res.sShowHideColumns}</span>
  </div>
  <div id="ajaxDataLogURL" class="hidden"><c:url value="/ajaxdatalog"/></div>
  <div id="isBackUPS" class="hidden">${isBackUPS}</div>
</body>
</html>