<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<html lang="${localeData.resourcesLocale}">
  <c:set var="res" value="${localeData.properties}"/>
  <c:set var="version" value="?${pcbeSettings.productVersion}"/>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="Expires" content="-1">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
    <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
    <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
    <link type="text/css" rel="stylesheet" href="/styles/jquery.cluetip.min.css${version}">
    <link type="text/css" rel="stylesheet" href="/styles/energyreporting.min.css${version}">
    <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
    <script type="text/javascript" src="/js/jquery.validate.min.js${version}"></script>
    <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
    <script type="text/javascript" src="/js/common.js${version}"></script>
    <script type="text/javascript" src="/js/jquery.cluetip.js${version}"></script>
    <script type="text/javascript" src="/js/energyreporting.js${version}"></script>
    <c:forEach var="jssrc" items="${page.scriptSource}">
        <script type="text/javascript" src="${jssrc}${version}"></script>
    </c:forEach>
    <title>${page.title}</title>
  </head>

  <body>
  <%@ include file="banner.jspf" %>
  <%@ include file="menu.jspf" %>
  <main id="contentcontainer">
  
    <h1 id="pageHeader">${page.header}</h1>

    <%-- holds error message warning --%>
    <div class="ui-corner-all" id="errorcontainer">
      ${res.ErrorBoxMsg}<br/><br/>
      ${res.EndDateBeforeStartDate}
    </div>
  
    <form id="formpageform" action="<c:url value='/setenergyreporting'/>" name="energyreportingform" method="post">

      <div id="mainbox">

        <div id="pcbereportingbox" class="label-value-group ui-corner-all">
          <div class="label-value-pair">                 
            <div id="startdatediv">
              <label>${res['Start.Date']}</label>
              <div class="valueEntry">
                <input
                  type="text"
                  value="${startdate}"
                  name="startdate"
                  class="datepicker textinput ui-corner-all editable required EndDateBeforeStartDateChecker"
                  id="startdate"
                  readonly="readonly"
                  maxlength="10"/>
              </div>
            </div>
              
            <div id="enddatediv">
              <label>${res['End.Date']}</label>
              <div class="valueEntry">
                <input
                  type="text"
                  value="${enddate}"
                  name="enddate"
                  class="datepicker textinput ui-corner-all editable required"
                  id="enddate"
                  readonly="readonly"
                  maxlength="10"/>
              </div>
            </div>

            <div id="button-bar">
              <input type="submit" value="${res.ButtonApply}" class="button" id="apply" name="apply" disabled="disabled"/>
            </div>
          </div>

          <div id="pcbeenergybox">
            <span id="pcbeenergykwh" class="pcbeenergy">
              <span class="pcbeenergytext pcbeenergytextheader">${res['Energy.Consumed']}</span>
              <span class="pcbeenergytext pcbeenergytextvalue">${energytotal}&nbsp;${res.KWH}</span>
            </span>
            <span id="pcbeenergycost" class="pcbeenergy">
              <span class="pcbeenergytext pcbeenergytextheader">${res['Cost.Incurred']}</span>
              <span class="pcbeenergytext pcbeenergytextvalue">${costtotal}</span>
            </span>
            <span id="pcbeenergyco2" class="pcbeenergy">
              <span class="pcbeenergytext pcbeenergytextheader">${res['CO2.Emitted']}</span>
              <span class="pcbeenergytext pcbeenergytextvalue">${co2total}&nbsp;${resWeightMeasurementSymbol}</span>
            </span>
          </div>
        </div>

        <c:if test="${not empty upsenergytotal}">
          <div class="label-value-group ui-corner-all" id="upsenergybox">
            <div class="label-value-pair" id="upsenergy">
              <div class="labelicon" id="upsenergyicon">&nbsp;</div>
              <label class="iconwidth">${res['EnergyReporting.UPSEnergy']}</label>
              <div class="value">${upsenergytotal}</div>
              <div class="unit">${res.KWH}</div>
            </div>                
          </div>
        </c:if>

      </div> <%-- mainbox --%>
      <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}"/>
      <input type="hidden" name="formtokenid" id="formtokenid" value="${formtokenid}"/>
    </form>

  </main>

  <div id="defaults">
    <span id="datepattern">${datepattern}</span>
    <span id="mindateyear">${mindateyear}</span>
    <span id="mindatemonth">${mindatemonth}</span>
    <span id="mindateday">${mindateday}</span>
    <span id="maxdateyear">${maxdateyear}</span>
    <span id="maxdatemonth">${maxdatemonth}</span>
    <span id="maxdateday">${maxdateday}</span>
  </div>
  <div id="res">     
    <span id="resNavigateAwayMsg">${res.NavigateAwayMsg}</span>
  </div>
  </body>
</html>