<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<html lang="${localeData.resourcesLocale}">
<c:set var="res" value="${localeData.properties}" />
<c:set var="version" value="?${pcbeSettings.productVersion}"/>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="Expires" content="-1">
  <meta http-equiv="Pragma" content="no-cache">
  <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
  <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
  <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
  <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
  <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
  <script type="text/javascript" src="/js/common.js${version}"></script>
  <title>${page.title}</title>
</head>
<body>
  <%@ include file="banner.jspf" %>
  <%@ include file="menu.jspf" %>
  <main id="contentcontainer">
    <form id="formpageform" action="<c:url value='${page.action}'/>" name="${page.name}" method="post">
    <div id="mainbox">
      <c:forEach var="lvp" items="${page.labelValuePairs}" varStatus="vs">
        <c:if test="${not empty lvp.subHeader}">
          <c:if test="${not vs.first}"></div></c:if>
          <h2<c:if test="${not empty lvp.cssClasses}"> class="${lvp.cssClassesAsString}"</c:if>>${lvp.subHeader}</h2>
          <div class="label-value-group ui-corner-all">
        </c:if>
        
        <%-- lvps can be wrapped inside a div by adding a start div id to the first lvp inside, and an end div to the last --%>
        <c:if test="${not empty lvp.startDivGroupClasses}"> <div <c:if test="${not empty lvp.startDivGroupTitle}">title="${lvp.startDivGroupTitle}"</c:if> class="${lvp.startDivGroupClasses}"></c:if>
        
        <div class="label-value-pair"<c:if test="${not empty lvp.id}"> id="${lvp.id}"</c:if>>
          <label<c:if test="${empty lvp.values}"> class="autowidth ${lvp.cssClassesAsString}"</c:if>>${lvp.label}</label>
          
          <c:if test="${not empty lvp.id && lvp.id == 'DebugInfoId'}">
          
             <div class="label-value-group ui-corner-all">
                 <div class="label-value-pair">
                   <label></label>
                   <div class="value">${applicationDirectory}PcssFiles-&#x3C${timeStamp}&#x3E.zip</div>
                 </div>
             </div>
             
             <div id="button-bar">
                 <input type="submit" value="${res.ButtonZipPcbeFiles}" class="button" id="clear" name="zip"/>
             </div>
          
          </c:if>
          
          <c:forEach var="stringvalue" items="${lvp.values}">
            <c:choose>
              <c:when test="${not empty stringvalue.id && stringvalue.id == 'autoUpdateId'}">
                <div class="value ${stringvalue.cssClassesAsString}" id="${stringvalue.id}"> ${stringvalue.value}</div>
              </c:when>
              <c:when test="${not empty stringvalue.id && stringvalue.id == 'releaseNotesId'}">
                <div class="fixedWidthSmallMedium" id="${stringvalue.id}">${stringvalue.value}</div>
              </c:when>
              <c:when test="${stringvalue.RESTButtonValue}">
                <select id="selectJRE" size="${fn:length(stringvalue.options)}">
                  <c:forEach var="optionVal" items="${stringvalue.options}">
                    <option value="${optionVal}">${optionVal}</option>
                  </c:forEach>
                </select>
                <button class="applyJRE" onclick="${stringvalue.function}(event)">${res.JREUpdateButton}</button>
                <div id="JRENote" class="WarningNote">
                  ${res.JREWarningNote}<br /><br />&#8226;&#160;${res.JREWarningNote1}<br /><br />&#8226;&#160;${res.JREWarningNote2}<br /><br />&#8226;&#160;${res.JREWarningNote3}
                </div>
              </c:when>
              <c:otherwise>
                <div <c:if test="${not empty stringvalue.id}">id="${stringvalue.id}" </c:if>class="fixedWidthSmallMedium">
                  <c:out value="${stringvalue.value}" />
                </div>
                <c:if test="${not empty stringvalue.unit}">
                  <div class="unit">${stringvalue.unit}</div>
                </c:if>
              </c:otherwise>
            </c:choose>
          </c:forEach>
        </div>
        
        <%-- lvps can be wrapped inside a div by adding a start div id to the first lvp inside, and an end div to the last --%>
        <c:if test="${lvp.endDivGroup}"></div></c:if>
        
        <c:if test="${vs.last}"></div></c:if>
      </c:forEach>
	  
    <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}"/>
    <input type="hidden" name="formtokenid" id="formtokenid" value="${formtokenid}"/>
	  
    </form>	
	
	<div id="res">
		<span id="resUpgradeConfirmA">${res.UpgradeConfirmA}</span>
		<span id="resUpgradeConfirmB">${res.UpgradeConfirmB}</span>
		<span id="resUpgradeRestarting">${res.UpgradeRestarting}</span>
		<span id="resUpgradeCanceled">${res.UpgradeCanceled}</span>
	</div>
  
  
  </main>
</body>
</html>