<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<html lang="${localeData.resourcesLocale}">
<c:set var="res" value="${localeData.properties}" />
<c:set var="version" value="?${pcbeSettings.productVersion}"/>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="Expires" content="-1">
  <meta http-equiv="Pragma" content="no-cache">
  <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
  <link type="text/css" rel="stylesheet" href="/styles/jquery.cluetip.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
  <link type="text/css" rel="stylesheet" href="/styles/pcbe-jquery-ui-overrides.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/loadshed.min.css${version}">
  <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
  <script type="text/javascript" src="/js/jquery.cluetip.js${version}"></script>
  <script type="text/javascript" src="/js/jquery.validate.min.js${version}"></script>
  <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
  <script type="text/javascript" src="/js/common.js${version}"></script>
  <script type="text/javascript" src="/js/loadshed.js${version}"></script>
  <title>${page.title}</title>
</head>
<body>
  <%@ include file="banner.jspf" %>
  <%@ include file="menu.jspf" %>
  <main id="contentcontainer">
    <h1 id="pageHeader">${page.header}</h1>
    
    <div id="config">        
      <div id="errorcontainer" class="ui-corner-all">
        ${res['ErrorBoxMsg']}
      </div>

      <c:choose> 
        <c:when test="${outletSystem.loadSheddingSupported}" > 
          <c:set var="sogs" value="${outletSystem.allOutletGroups}" />
         <form id="formpageform" action="<c:url value='${page.action}'/>" name="${page.name}" method="post">
            <div id="loadshedwarning${vs.index}">
              <div class="warningbox ui-corner-all"> 
                <div class="warningtext">
                  <span class="warningimg"></span>
                  <c:out value="${res.WarningMsg1}"/>
                </div>
              </div>
            </div>

            <div id="tabs">
              <ul>
                <c:forEach var="sog" items="${sogs}" varStatus="vs">
                  <c:if test="${sog.loadShedding_supported}" >
                    <li>
                      <a href="#sog${vs.index}">
                        <c:if test="${sog.pcbeOutlet}">
                          <span class="server_small_img tab_server_img" id="tab_server_img${vs.index}"></span>
                        </c:if>
                        <c:if test="${sog.targetOutlet && not sog.pcbeOutlet}">
                          <span class="shutdown_small_img tab_shutdown_img" id="tab_shutdown_img${vs.index}"></span>
                        </c:if>
                        <span class="ui-label" id="outletName${vs.index}tab"><c:out value="${empty sog.outletName ? sog.outletLabel : sog.outletName}"/></span>
                      </a>
                    </li>
                  </c:if>
                </c:forEach>
              </ul>
              <c:forEach var="sog" items="${sogs}" varStatus="vs">
                <c:if test="${sog.loadShedding_supported}">
                  <div id="sog${vs.index}" class="sog" mog="${sog.mainOutlet}">
                    <div id="sogtabs${vs.index}" class="sogtabs">
                      <div id="loadshedding${vs.index}" class="sogcfg loadshedcfg">                      
                        <div id="conditions" class="label-value-group ui-corner-all">
                          <div class="label-value-pair">
                            <label class="labelauto">${res.LoadShedConditionsTitle}</label>
                          </div>

                          <c:if test="${sog.timeOnBattery_supported}">
                            <div class="label-value-pair">
                              <input
                                type="checkbox"
                                name="timeOnBatteryCheck${vs.index}"
                                id="timeOnBatteryCheck${vs.index}"
                                class="checkbox inputcheck"
                                value="${vs.index}"
                                ${sog.timeOnBattery_enabled ? 'checked="checked"' : ''} />
                              <label for="timeOnBatteryCheck${vs.index}">${res.TimeOnBattery}</label>
                              <div class="valueEntry">
                                <input
                                  type="text"
                                  value="${sog.loadShedTimeOnBatterySetting}"
                                  name="timeOnBattery${vs.index}"
                                  class="textinput ui-corner-all configsecs required posint editable"
                                  min="${sog.minLoadShedTimeOnBattery}"
                                  max="${sog.maxLoadShedTimeOnBattery}"
                                  id="timeOnBattery${vs.index}"
                                  maxlength="5"/> <%-- could make this dynamic in future versions - like min and max values --%>
                                <div class="unit">${res.SeondsLabelShort}</div>
                              </div>
                            </div>
                          </c:if>
                          <c:if test="${sog.runTimeRemaining_supported}">
                            <div class="label-value-pair">
                              <input
                                type="checkbox"
                                name="runtimeRemainingCheck${vs.index}"
                                id="runtimeRemainingCheck${vs.index}"
                                class="checkbox inputcheck"
                                value="${vs.index}"
                                ${sog.runTimeRemaining_enabled ? 'checked="checked"' : ''} />
                              <label for="runtimeRemainingCheck${vs.index}">${res.LoadShedRuntimeRemaining}</label>
                              <div class="valueEntry">
                                <input
                                  type="text"
                                  value="${sog.loadShedRunTimeRemainingSetting}"
                                  name="runtimeRemaining${vs.index}"
                                  class="textinput ui-corner-all configsecs required posint editable"
                                  min="${sog.minLoadShedRunTimeRemaining}"
                                  max="${sog.maxLoadShedRunTimeRemaining}"
                                  id="runtimeRemaining${vs.index}"
                                  maxlength="4"/> <%-- could make this dynamic in future versions - like min and max values --%>
                                <div class="unit">${res.SeondsLabelShort}</div>
                              </div>
                            </div>
                          </c:if>
                          <c:if test="${sog.loadThreshold_supported}">
                            <div class="label-value-pair">
                              <input
                                type="checkbox"
                                name="loadTresholdCheck${vs.index}"
                                id="loadTresholdCheck${vs.index}"
                                class="checkbox inputcheck"
                                value="${vs.index}"
                                ${sog.loadThreshold_enabled ? 'checked="checked"' : ''} />
                              <c:choose>
                                <c:when test="${sog.loadShedThreshold_Pct_supported}">
                                  <label for="loadTresholdCheck${vs.index}">${res.LoadTreshold}</label>
                                  <div class="valueEntry">
                                    <input
                                      type="text"
                                      value="${sog.loadShedThreshold_Pct}"
                                      name="loadTreshold${vs.index}"
                                      class="textinput ui-corner-all configpct required posint editable"
                                      min="${sog.minLoadShedThreshold_Pct}"
                                      max="${sog.maxLoadShedThreshold_Pct}"
                                      id="loadTreshold${vs.index}"
                                      maxlength="3"/> <%-- could make this dynamic in future versions - like min and max values --%>
                                    <div class="unit">${res.PercentageShortHint}</div>
                                  </div>
                                  <c:if test="${sog.loadRestartThreshold_supported}">
                                    <%-- TODO: restart treshold --%>
                                  </c:if>
                                </c:when>
                                <c:otherwise>
                                  <label class="labelauto" for="loadTresholdCheck${vs.index}">${res.Overload}</label>
                                </c:otherwise>
                              </c:choose>
                            </div>
                          </c:if>
                        </div>
                        <c:if test="${sog.loadShedding_supported}">
                          <div class="label-value-group ui-corner-all">
                            <div class="label-value-pair">
                              <label class="labelauto">${res.LoadShedActionsTitle}</label>
                            </div>
                            <c:if test="${sog.useOffDelay_supported}">
                              <div class="label-value-pair">
                                <input
                                  type="checkbox"
                                  name="useStayOff${vs.index}"
                                  class="checkbox inputcheck"
                                  id="useStayOff${vs.index}"
                                  value="${vs.index}"
                                  ${sog.loadShed_UseOffDelay_enabled ? 'checked="checked"' : ''} />
                                <label for="useStayOff${vs.index}">${res.UseStayOffDelay}</label>
                                <div class="value"><c:out value="${sog.turnOffCountdownSetting}"/></div>
                                <div class="unit">${res.SeondsLabelShort}</div>
                              </div>
                            </c:if>
                            <c:if test="${sog.manRestartRequired_supported}">
                              <div class="label-value-pair">
                                <input
                                  type="checkbox"
                                  name="loadShedManualTurnOn${vs.index}"
                                  class="checkbox"
                                  id="loadShedManualTurnOn${vs.index}"
                                  value="${vs.index}"
                                  ${sog.loadShed_ManRestartRequired_enabled ? '' : 'checked="checked"'} />
                                <label class="labelauto" for="loadShedManualTurnOn${vs.index}">${res.LoadShedManualTurnOn}</label>
                              </div>
                            </c:if>
                          </div>
                        </c:if>
                      </div> <%-- loadsheddingN --%> 
                    </div> <%-- sogtabsN --%>
                  </div> <%-- sogN --%>
                </c:if>
              </c:forEach>
            </div>

            <%@ include file="button.jspf" %>

            <%-- hidden input field to store the selected tab --%>
            <input type="hidden" name="selectedTabLS" id="selectedTab" value="${selectedTabLS}"/>
            <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}"/>
            <input type="hidden" name="formtokenid" id="formtokenid" value="${formtokenid}"/>

          </form>
          <div id="submitdialog" title="${res.SubmitDialogTitle}">
            <p>${res.SubmitDialogContent}</p>
            <p class="waitimg"><img src="/styles/images/wait.gif${version}"/></p>
          </div>
        </c:when>
        <c:otherwise> 
          <div class="label-value-pair">
            <label class="labelauto">${res.LoadShedNotSupportedTitle}</label>
          </div>
        </c:otherwise> 
      </c:choose>

    </div> <%-- config --%>

  </main> <%-- container --%>
  <div id="res">
    <span id="resSeondsLabelShort">${res.SeondsLabelShort}</span>
    <span id="resPercentageShortHint">${res.PercentageShortHint}</span>
    <span id="resRequiredError">${res.FieldRequired}</span>
    <span id="resMinSecondsError">${res.MinSecondsError}</span>
    <span id="resMaxSecondsError">${res.MaxSecondsError}</span>
    <span id="resMinPercentageError">${res.MinPercentageError}</span>
    <span id="resMaxPercentageError">${res.MaxPercentageError}</span>
    <span id="resNotANumberError">${res.NotANumberError}</span>
    <span id="resNavigateAwayMsg">${res.NavigateAwayMsg}</span>
  </div>
</body>
</html>