<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<html lang="${localeData.resourcesLocale}">
<c:set var="res" value="${localeData.properties}" />
<c:set var="version" value="?${pcbeSettings.productVersion}"/>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="Expires" content="-1">
  <meta http-equiv="Pragma" content="no-cache">
  <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
  <link type="text/css" rel="stylesheet" href="/styles/jquery.cluetip.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
  <link type="text/css" rel="stylesheet" href="/styles/pcbe-jquery-ui-overrides.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/login.min.css${version}">
  <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
  <script type="text/javascript" src="/js/jquery.cluetip.js${version}"></script>
  <script type="text/javascript" src="/js/jquery.validate.min.js${version}"></script>
  <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
  <script type="text/javascript" src="/js/common.js${version}"></script>
  <script type="text/javascript" src="/js/login.js${version}"></script>
  <title>${page.title}</title>
</head>
<body>
  <%@ include file="banner.jspf" %>
  <main id="contentcontainer">
    <div id="loginHeader" class="ui-corner-all">
      <span id="loginHeaderTitle">${res.Login}</span>
    </div>
    <div id="loginLogo"></div>
    <div id="loginBox">
      <form name="${page.name}" id="${page.name}" method="post" action="<c:url value='${page.action}'/>">
        <div class="label-value-group ui-widget-content ui-corner-all">
          <div class="label-value-pair">
            <label for="j_username">${res.Username}</label>
            <input
                type="text"
                id="username"
                name="j_username"
                class="text-input editable ui-widget-content ui-corner-all"
                value=""
                maxlength="128"
                autocomplete="off"/>
          </div>
		  <div class="hidden">
			<input type="password"/>
		  </div>
          <div class="label-value-pair">
            <label for="j_password">${res.Password}</label>
            <input
                type="password"
                id="password"
                name="j_password"
                class="text-input editable ui-widget-content ui-corner-all"
                value=""
                maxlength="128"
                autocomplete="off"/>
          </div>
          <c:if test="${not empty loginInvalid}">
            <div id="loginInvalid">
              <c:out value="${res.LoginInvalid }" />
            </div>
          </c:if>
          <c:if test="${not empty alreadyLoggedOn}">
            <div id="alreadyLoggedOn">
              <c:out value="${res.AlreadyLoggedOn}" />
            </div>
          </c:if>
          <c:if test="${not empty lockedOut}">
            <div id="lockedOut">
              <c:out value="${res.LockedOut}" />
            </div>
          </c:if>
        </div>
        <div id="button-bar">
          <input type="submit" id="loginButton" name="login" class="button" value="${res.Login}" />
        </div>
        <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}"/>
        <input type="hidden" name="formtokenid" id="formtokenid" value="${formtokenid}"/>
      </form>
    </div>
  </main>
  <div id="res">
    <span id="resMinPasswordLength">${res.MinPasswordLength}</span>
    <span id="resUsernameRequired">${res.UsernameRequired}</span>
    <span id="resPasswordRequired">${res.PasswordRequired}</span>
  </div>
</body>
</html>