<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<html lang="${localeData.resourcesLocale}">
<c:set var="res" value="${localeData.properties}" />
<c:set var="version" value="?${pcbeSettings.productVersion}"/>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="Expires" content="-1">
  <meta http-equiv="Pragma" content="no-cache">
  <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
  <link type="text/css" rel="stylesheet" href="/styles/jquery.cluetip.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
  <link type="text/css" rel="stylesheet" href="/styles/pcbe-jquery-ui-overrides.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/outletcfg.min.css${version}">
  <c:if test="${wizard}"><link type="text/css" rel="stylesheet" href="/styles/shutdownwizard.min.css${version}"></c:if>
  <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
  <script type="text/javascript" src="/js/jquery.cluetip.js${version}"></script>
  <script type="text/javascript" src="/js/jquery.validate.min.js${version}"></script>
  <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
  <script type="text/javascript" src="/js/common.js${version}"></script>
  <script type="text/javascript" src="/js/outletcfg.js${version}"></script>
  <c:if test="${wizard}"><script type="text/javascript" src="/js/shutdownwizard.js${version}"></script></c:if>
  <title>${page.title}</title>
</head>
<body>
  <%@ include file="banner.jspf" %>
  <%@ include file="menu.jspf" %>
  <%@ include file="shutdownwizardmenu.jspf" %>
  <main id="contentcontainer">
    <h1 id="pageHeader">${page.header}</h1>

    <form id="formpageform" action="<c:url value='${page.action}'/>" name="${page.name}" method="post">

      <c:set var="sogs" value="${outletSystem.allOutletGroups}" />
      <c:set var="osShutdown" value="${osShutdown}" />

      <div id="topbox">
        <div class="ui-corner-all" id="timeline">
          <c:forEach var="sog" items="${sogs}" varStatus="vs">
            <div id="sogTime${vs.index}" class="sogtime ui-corner-all">
              <div class="timebox shutdown" id="shutdown${vs.index}timebox" title="${res.OSShutdownDelayHint}"></div>
              <c:if test="${sog.mainOutlet}">
                <div class="timebox stateOn" id="stateOn${vs.index}timebox" title="${res.OutletRemainsOnHint}"></div>
              </c:if>
              <c:choose>
                <c:when test="${sog.pcbeOutlet}">
                  <div class="timebox turnOff" id="turnOff${vs.index}timebox" title="${res.TurnOffDelayShutdownHint}"></div>
                </c:when>
                <c:otherwise>
                  <div class="timebox turnOff" id="turnOff${vs.index}timebox" title="${res.TurnOffDelayHint}"></div>
                </c:otherwise>
              </c:choose>
              <c:if test="${not sog.mainOutlet}">
                <div class="timebox remainOff" id="stateOff${vs.index}timebox" title="${res.StayOffDelayHint}"></div>
              </c:if>
              <%-- UPSLink units only allow stay off in 6 minute increments.  As max is 5 minutes, change tooltip text  --%>
              <div class="timebox stayOff" id="stayOff${vs.index}timebox" title="${isUPSLink ? res.StayOffDelayHintUPSLink : res.StayOffDelayHint}"></div>

              <c:if test="${not sog.mainOutlet}">
                <div class="timebox stateOff" id="remainOff${vs.index}timebox" title="${res.OutletOffHint}"></div>
              </c:if>
              <div class="timebox turnOn" id="turnOn${vs.index}timebox" title="${res.TurnOnDelayHint}"></div>
              <div class="timebox timeright" id="stateOnRight${vs.index}timebox" title="${res.OutletOnHint}"></div>
            </div>
          </c:forEach>
          <div id="timescale">
            <div class="timescalebar" id="timescalebar"></div>
            <div class="timescalebar" id="timescalebarOn"></div>
            <div id="timescaletext"></div>
          </div>
        </div> <%-- timeline --%>
        <div class="ui-corner-all" id="outletinfobox">
          <c:forEach var="sog" items="${sogs}" varStatus="vs">
            <div class="outletinfo ui-corner-all" id="outletinfo${vs.index}">
              <div class="outletinfoserver">
                <div class="server">
                  <c:if test="${sog.pcbeOutlet}">
                    <img src="/images/pcbeserver_medium.png${version}" class="serverimg" id="serverimg${vs.index}" title="${res.PCBEServerHint}"/>
                  </c:if>
                </div>
              </div>
              <div class="outletinfoname">
                <div id="outletName${vs.index}top" class="outletnametop"><c:out value="${empty sog.outletName ? sog.outletLabel : sog.outletName}"/></div>
              </div>
            </div>
          </c:forEach>
        </div>
        <div class="ui-corner-all" id="legend">
          <div class="legendEntry">
            <div class="legendbox timeright"></div>
            <div class="value">${res.OutletOnLegend}</div>
          </div>
          <div class="legendEntry">
            <div class="legendbox remainOff"></div>
            <div class="value">${res.OutletOffLegend}</div>
          </div>
        </div> <%-- legend --%>
      </div> <%-- topbox --%>

      <div id="centerbox">
        <div id="config">
          <div class="ui-corner-all" id="errorcontainer">
            ${res['ErrorBoxMsg']}
          </div>

          <div class="label-value-group ui-corner-all">
            <div class="label-value-pair" id="generalManualTurnOn">
              <input
                type="checkbox"
                name="manualTurnOn"
                class="manualTurnOn checkbox"
                id="manualTurnOn"
                value="0"
                ${outletSystem.manualTurnOn ? '' : 'checked="checked"'} />
              <label class="labelauto" for="manualTurnOn">${res.ManualTurnOn}</label>
            </div>
          </div>

          <div id="tabs">
            <ul>
              <c:forEach var="sog" items="${sogs}" varStatus="vs">
                <li><a href="#sog${vs.index}">
                  <c:choose>
                    <c:when test="${sog.pcbeOutlet}">
                      <c:set var="pcbeoutletgroup" value="${vs.index}"/>
                      <span class="server_small_img tab_server_img" id="tab_server_img${vs.index}"></span>
                    </c:when>
                    <c:otherwise>
                      <span class="shutdown_small_img tab_shutdown_img" id="tab_shutdown_img${vs.index}"></span>
                    </c:otherwise>
                  </c:choose>
                  <span class="ui-label" id="outletName${vs.index}tab"><c:out value="${empty sog.outletName ? sog.outletLabel : sog.outletName}"/></span>
                </a></li>
              </c:forEach>
            </ul>

            <c:forEach var="sog" items="${sogs}" varStatus="vs">
              <div id="sog${vs.index}" class="sog" mog="${sog.mainOutlet}">
                <div id="general${vs.index}">
                  <div class="label-value-group ui-corner-all">
                    <div class="label-value-pair">
                      <div class="shutdown_small_img"></div>
                      <label class="labelimg" for="pcbeshutdown${vs.index}">${res.ShutdownTarget}</label>
                      <input
                        type="checkbox"
                        name="target${vs.index}"
                        class="pcbeshutdown checkbox"
                        id="pcbeshutdown${vs.index}"
                        value="${vs.index}"
                        ${sog.targetOutlet ? 'checked="checked"' : ''} />
                    </div>
                  </div>
                </div>
                <div id="sogtabs${vs.index}" class="sogtabs">
                  <div class="delayheader ui-widget-header ui-helper-clearfix ui-corner-top">
                    <span>${res.OffDelaysAccordion}</span>
                  </div>
                  <div id="offdelays${vs.index}" class="sogcfg ui-corner-bottom">
                    <div class="label-value-group ui-corner-all">
                      <div class="label-value-pair shutdowndelay" id="shutdowndelay${vs.index}">
                        <div class="legendbox shutdown"></div>
                        <label class="labelimg">${res.OSShutdownDelay}</label>
                        <div class="value" id="shutdown${vs.index}">${osShutdown.OSShutdownDelay}</div>
                        <div class="unit">${res.SeondsLabelShort}</div>
                      </div>
                      <c:if test="${sog.mainOutlet}">
                        <div class="label-value-pair" id="mogremainon">
                          <div class="legendbox stateOn"></div>
                          <label class="labelimg">${res.RemainOnDelay}</label>
                          <div class="value" id="mogremainonvalue"></div>
                          <div class="unit">${res.SeondsLabelShort}</div>
                        </div>
                      </c:if>
                      <div class="label-value-pair" id="turnOffDelay${vs.index}">
                        <div class="legendbox turnOff"></div>
                        <label class="labelimg" for="turnOff${vs.index}">${res.TurnOffDelay}</label>
                        <div class="valueEntry">
                          <input
                            type="text"
                            value="${sog.turnOffCountdownSetting}"
                            name="turnOffCountdownSetting${vs.index}"
                            class="textinput ui-corner-all turnOff delay configsecs required posint editable"
                            min="${sog.minTurnOffCountdownSetting}"
                            max="${sog.maxTurnOffCountdownSetting}"
                            id="turnOff${vs.index}"
                            maxlength="4"/> <%-- could make this dynamic in future versions - like min and max values --%>
                          <div class="unit">${res.SeondsLabelShort}</div>
                        </div>
                      </div>
                      <c:if test="${sog.pcbeOutlet}">
                        <div class="label-value-pair">
                          <div class="legendbox turnOff"></div>
                          <label class="labelimg">${res.TurnOffDelayShutdown}</label>
                          <div class="value">${sog.turnOffCountdownSetting}</div>
                          <div class="unit">${res.SeondsLabelShort}</div>
                        </div>
                        <div class="label-value-pair totalshutdownrow" id="totalshutdownrow${vs.index}">
                          <label>${res.TotalOSShutdown}</label>
                          <div class="value totalshutdown" id="totalshutdown${vs.index}"></div>
                          <div class="unit">${res.SeondsLabelShort}</div>
                        </div>
                      </c:if>
                    </div>
                  </div> <%-- offdelaysN --%>
                  <div class="turnondelays delayheader ui-widget-header ui-helper-clearfix ui-corner-top" id="turnondelays${vs.index}">
                    <span>${res.OnDelaysAccordion}</span>
                  </div>
                  <div id="ondelays${vs.index}" class="sogcfg ondelays ui-corner-bottom">

                    <%-- UPSLink units only allow stay off in 6 minute increments.  As max is 5 minutes, no point in displaying  --%>
                    <c:if test="${!isUPSLink}">
                      <div class="label-value-group ui-corner-all">
                        <div class="label-value-pair">
                          <div class="legendbox stayOff"></div>
                          <label class="labelimg" for="stayOff${vs.index}">${res.StayOffDelay}</label>
                          <div class="valueEntry">
                            <input
                              type="text"
                              value="${sog.stayOffCountdownSetting}"
                              name="stayOffCountdownSetting${vs.index}"
                              class="textinput ui-corner-all stayOff delay configsecs required posint editable"
                              min="${sog.minStayOffCountdownSetting}"
                              max="${sog.maxStayOffCountdownSetting}"
                              id="stayOff${vs.index}"
                              maxlength="4"/> <%-- could make this dynamic in future versions - like min and max values --%>
                            <div class="unit">${res.SeondsLabelShort}</div>
                          </div>
                        </div>
                        <div class="label-value-pair sogremainoff" id="sogremainoff${vs.index}">
                          <div class="legendbox stayOff"></div>
                          <label class="labelimg">${res.RemainOffDelay}</label>
                          <div class="value" id="sogremainoffvalue${vs.index}"></div>
                          <div class="unit">${res.SeondsLabelShort}</div>
                        </div>
                      </div>
                    </c:if>

                    <c:if test="${isMininumReturnRuntimeSupported}">
                      <div class="label-value-group ui-corner-all">
                        <div class="label-value-pair">
                          <label for="minRuntime${vs.index}">
                            ${isUPSLink ? res.MinReturnCharge : res.MinReturnRuntime}
                          </label>
                          <div class="valueEntry">

                            <%-- UPSLink units only allow return charge in discrete % increments. --%>
                            <c:if test="${!isUPSLink}">
                              <input
                                type="text"
                                value="${sog.minimumReturnRuntimeSetting}"
                                name="minimumReturnRuntimeSetting${vs.index}"
                                id="minRuntime${vs.index}"
                                class="textinput ui-corner-all configsecs required posint editable"
                                min="${sog.minMinimumReturnRuntimeSetting}"
                                max="${sog.maxMinimumReturnRuntimeSetting}"
                                maxlength="4"/> <%-- could make this dynamic in future versions - like min and max values --%>
                            </c:if>

                            <c:if test="${isUPSLink}">
                              <select id="minRuntime${vs.index}"
                                name="minimumReturnRuntimeSetting${vs.index}"
                                size="1"
                                class="dropdown ui-corner-all configpct delay editable">
                                <c:forEach var="selectOption" items="${returnChargeData.optionList}" varStatus="option">
                                  <c:choose>
                                    <c:when test="${returnChargeData.selectedIndex == option.index}">
                                      <option value="${selectOption.value}" selected="selected"><c:out value="${selectOption.displayValue}"/></option>
                                    </c:when>
                                    <c:otherwise>
                                      <option value="${selectOption.value}"><c:out value="${selectOption.displayValue}"/></option>
                                    </c:otherwise>
                                  </c:choose>
                                </c:forEach>
                              </select>
                            </c:if>

                            <div class="unit">
                              ${isUPSLink ? res.Percent : res.SeondsLabelShort}
                            </div>
                          </div>
                        </div>
                      </div>
                    </c:if>

                    <div class="label-value-group ui-corner-all ondelaysfieldset">
                      <c:if test="${not sog.mainOutlet}">
                        <div class="label-value-pair sogwaitformog" id="sogwaitformog${vs.index}">
                          <div class="legendbox stateOff"></div>
                          <label class="labelimg">${res.RemainOffDelay}</label>
                          <div class="value" id="sogwaitformogvalue${vs.index}"></div>
                          <div class="unit">${res.SeondsLabelShort}</div>
                        </div>
                      </c:if>
                      <div class="label-value-pair">
                        <div class="legendbox turnOn"></div>
                        <label class="labelimg" for="turnOn${vs.index}">${res.TurnOnDelay}</label>

                        <%-- UPSLink units only allow turn on in 1 minute increments. --%>
                        <c:if test="${!isUPSLink}">
                          <div class="valueEntry">
                            <input
                              type="text"
                              value="${sog.turnOnCountdownSetting}"
                              name="turnOnCountdownSetting${vs.index}"
                              class="textinput ui-corner-all turnOn delay configsecs required posint editable"
                              min="${sog.minTurnOnCountdownSetting}"
                              max="${sog.maxTurnOnCountdownSetting}"
                              id="turnOn${vs.index}"
                              maxlength="4"/> <%-- could make this dynamic in future versions - like min and max values --%>
                            <div class="unit">${res.SeondsLabelShort}</div>
                          </div>
                        </c:if>

                        <c:if test="${isUPSLink}">
                          <select id="turnOn${vs.index}"
                            name="turnOnCountdownSetting${vs.index}"
                            size="1"
                            class="dropdown ui-corner-all turnOn delay editable">
                            <c:forEach var="selectOption" items="${turnOnDelayData.optionList}" varStatus="option">
                              <c:choose>
                                <c:when test="${turnOnDelayData.selectedIndex == option.index}">
                                  <option value="${selectOption.value}" selected="selected"><c:out value="${selectOption.displayValue}"/></option>
                                </c:when>
                                <c:otherwise>
                                  <option value="${selectOption.value}"><c:out value="${selectOption.displayValue}"/></option>
                                </c:otherwise>
                              </c:choose>
                            </c:forEach>
                          </select>
                        </c:if>

                      </div>
                    </div>
                  </div> <%-- ondelaysN --%>
                </div> <%-- sogtabsN --%>
              </div> <%-- sogN --%>
            </c:forEach>
          </div> <%-- tabs --%>
        </div> <%-- config --%>

        <div id="alertMessageDialog" class="dialog"></div>

        <%-- hidden input field to store pcbe outlet --%>
        <input type="hidden" name="pcbeoutlet" id="pcbeoutlet" value="${pcbeoutletgroup}"/>

        <%-- hidden input field to store the selected tab --%>
        <input type="hidden" name="selectedTab" id="selectedTab" value="${selectedTab}"/>

        <c:if test="${not wizard}">
          <div id="submitbox">
            <button type="submit" id="apply" class="button">${res.ButtonApply}</button>
          </div>
        </c:if>

      </div> <%-- centerbox --%>
      <%@ include file="shutdownwizardbutton.jspf" %>
      <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}"/>
      <input type="hidden" name="formtokenid" id="formtokenid" value="${formtokenid}"/>
    </form>
    <div id="submitdialog" title="${res.SubmitDialogTitle}">
      <p>${res.SubmitDialogContent}</p>
      <p class="waitimg"><img src="/styles/images/wait.gif${version}"/></p>
    </div>
  </main> <%-- container --%>
  <div id="res">
    <span id="resShutdownTarget">${res.ShutdownTarget}</span>
    <span id="resShutdownTargetInput">${res.ShutdownTargetInput}</span>
    <span id="resRemainOnDelay1">${res.RemainOnDelay1}</span>
    <span id="resRemainOnDelay2">${res.RemainOnDelay2}</span>
    <span id="resWaitingForMOGDelay1">${res.WaitingForMOGDelay1}</span>
    <span id="resWaitingForMOGDelay2">${res.WaitingForMOGDelay2}</span>
    <span id="resTurnOffDelay">${res.TurnOffDelay}</span>
    <span id="resTurnOffDelayShutdown">${res.TurnOffDelayShutdown}</span>
    <span id="resSeondsLabelShort">${res.SeondsLabelShort}</span>
    <span id="resTurnOffDelayHint">${res.TurnOffDelayHint}</span>
    <span id="resTurnOffDelayShutdownHint">${res.TurnOffDelayShutdownHint}</span>
    <span id="resStayOffDelayHint">${res.StayOffDelayHint}</span>
    <span id="resTurnOnDelayHint">${res.TurnOnDelayHint}</span>
    <span id="resOSShutdownDelayHint">${res.OSShutdownDelayHint}</span>
    <span id="resOutletRemainsOnHint">${res.OutletRemainsOnHint}</span>
    <span id="resOutletOnHint">${res.OutletOnHint}</span>
    <span id="resOutletOffHint">${res.OutletOffHint}</span>
    <span id="resOutletRemainsOffHint">${res.OutletRemainsOffHint}</span>
    <span id="resColonHint">${res.ColonHint}</span>
    <span id="resSecondsShortHint">${res.SecondsShortHint}</span>
    <span id="resSecondsLongHint">${res.SecondsLongHint}</span>
    <span id="resMinutesLongHint">${res.MinutesLongHint}</span>
    <span id="resRequiredError">${res.FieldRequired}</span>
    <span id="resMinSecondsError">${res.MinSecondsError}</span>
    <span id="resMaxSecondsError">${res.MaxSecondsError}</span>
    <span id="resMinPercentageError">${res.MinPercentageError}</span>
    <span id="resMaxPercentageError">${res.MaxPercentageError}</span>
    <span id="resNotANumberError">${res.NotANumberError}</span>
    <span id="resNavigateAwayMsg">${res.NavigateAwayMsg}</span>
    <span id="resErrorLoadingMsg">${res.ErrorLoadingMsg}</span>
    <span id="resClose">${res.Close}</span>
    <span id="resButtonOK">${res.ButtonOK}</span>
    <c:if test="${schedules}"><span id="resChangeDelaysScheduleWarningTitle">${res.ChangeDelaysScheduleWarningTitle}</span></c:if>
    <c:if test="${schedules}"><span id="resChangeDelaysScheduleWarningMessage">${res.ChangeDelaysScheduleWarningMessage}</span></c:if>
    <c:if test="${isUPSLink}"><span id="isUPSLink">isUPSLink</span></c:if>
  </div>
</body>
</html>