<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="pcssfn" uri="PCSSFunctions"%>
<html lang="${localeData.resourcesLocale}">
<c:set var="res" value="${localeData.properties}" />
<c:set var="version" value="?${pcbeSettings.productVersion}"/>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="Expires" content="-1">
  <meta http-equiv="Pragma" content="no-cache">
  <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
  <link type="text/css" rel="stylesheet" href="/styles/jquery.cluetip.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
  <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/outletsetup.min.css${version}">
  <c:if test="${wizard}"><link type="text/css" rel="stylesheet" href="/styles/shutdownwizard.min.css${version}"></c:if>
  <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
  <script type="text/javascript" src="/js/jquery.cluetip.js${version}"></script>
  <script type="text/javascript" src="/js/jquery.validate.min.js${version}"></script>
  <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
  <script type="text/javascript" src="/js/common.js${version}"></script>
  <script type="text/javascript" src="/js/outletsetup.js${version}"></script>
  <c:if test="${wizard}"><script type="text/javascript" src="/js/shutdownwizard.js${version}"></script></c:if>
  <title>${page.title}</title>
</head>
<body>
  <%@ include file="banner.jspf" %>
  <%@ include file="menu.jspf" %>
  <%@ include file="shutdownwizardmenu.jspf" %>
  <main id="contentcontainer">
    <h1 id="pageHeader">${page.header}</h1>
   
    <c:choose>
      <c:when test="${outletSystem.outletSetupSupported}">
        <c:set var="sogs" value="${outletSystem.allOutletGroups}" />
        <c:set var="pcbeDefaultOG" value="${outletSystem.defaultPCBEOutletGroup}" />
    
        <form id="formpageform" action="<c:url value='${page.action}'/>" name="${page.name}" method="post">
    
          <%-- Main container for page --%>
          <div id="mainbox">
    
            <%-- PCBE Outlet Selection Panel --%>
            <c:if test="${isMultipleOutletGroups}">
              <h2><c:out value="${res.PCBESelectionTitle}"/></h2>
    
              <div class="label-value-group">
    
                <%-- Show the default PCBE outlet groups selection check box, only if outlets have not been configured yet --%>
                <c:if test="${!outletSystem.outletsHaveBeenConfigured}">                
    
                  <%-- default PCBE confirmation message --%>
                  <c:choose>               
                    <c:when test="${empty pcbeDefaultOG}">
    
                      <%-- If there isn't a default PCBE OG, change the message and don't show the check box --%>
                      <div class="pcbeSelectionDefaultText">
                          ${res.PCBESelectionNoDefault}
                      </div>  
    
                    </c:when>
                    <c:otherwise>
    
                      <%-- There IS a default PCBE OG, change the message and show the check box--%>
                      <div class="pcbeSelectionDefaultText">
                          <c:out value="${pcssfn:format1(res.PCBEDefaultSelection, pcbeDefaultOG.outletLabel)}"/>
                      </div>
    
                      <%-- default PCBE confirmation check box, always unchecked, value not important --%>
                      <div class="label-value-pair">
                        <%-- spacer div --%>
                        <label for="pcbeDefaultCheckbox">${pcssfn:format1(res.PCBEDefaultCheckboxLabel, pcbeDefaultOG.outletLabel)}</label>
                        <div class="valueEntry">
                          <input
                            type="checkbox"
                            name="pcbeDefaultCheckbox"
                            id="pcbeDefaultCheckbox"
                            class="checkbox"
                            value="checked"/>
                        </div>
                      </div>    
    
                    </c:otherwise>
                  </c:choose>    
                </c:if>
    
                <div class="label-value-pair">           
                  <label for="pcbeOutletSelect">${res.PCBEServer}</label>
                  <select id="pcbeOutletSelect" name="pcbeOutletSelect" class="dropdown ui-corner-all editable <c:if test="${schedules}">schedules</c:if>" size="1">
                    <c:forEach var="sog" items="${sogs}" varStatus="vs">
                      <%-- Indexes for units without MOG should start at 1 --%>
                      <c:set var="OGIndex" value="${vs.index}" />
                      <c:if test="${!outletSystem.mainOutletGroup}">
                        <c:set var="OGIndex" value="${vs.index + 1}" />
                      </c:if>
                      <c:set var="OGName" value="${empty sog.outletName ? sog.outletLabel : sog.outletName}"/>
                      <c:choose>
                      <%-- Select the PCBE outlet group on page generation --%>
                        <c:when test="${sog.pcbeOutlet}">
                          <option selected value="${OGIndex}" id="outletName${OGIndex}option" <c:if test="${pcbeDefaultOG.outletGroupIndex == OGIndex}">class="pcbeDefaultOutletOption"</c:if>><c:out value="${OGName}"/></option>
                        </c:when>
                        <c:otherwise>
                          <option value="${OGIndex}" id="outletName${OGIndex}option" <c:if test="${pcbeDefaultOG.outletGroupIndex == OGIndex}">class="pcbeDefaultOutletOption"</c:if>><c:out value="${OGName}"/></option>
                        </c:otherwise>
                      </c:choose>
                    </c:forEach>
                  </select>           
                </div>
    
              </div>
            </c:if>
    
            <%-- Outlet Names Panel --%>
            <c:if test="${outletSystem.renamingOutletGroupsSupported}">
              <h2><c:out value="${res.OutletGroupNamingTitle}"/></h2>
              <div class="label-value-group">
                <c:forEach var="sog" items="${sogs}" varStatus="vs">
    
                  <%-- Indexes for units without MOG should start at 1 --%>
                  <c:set var="OGIndex" value="${vs.index}" />
                  <c:if test="${!outletSystem.mainOutletGroup}">
                    <c:set var="OGIndex" value="${vs.index + 1}" />
                  </c:if>
                  <c:set var="OGName" value="name${OGIndex}"/>            
    
                  <c:if test="${sog.outletNameSupported}">
                    <div class="label-value-pair">
                      <%-- labelicon div ensures width remains static even when image is hidden. img class is used as jquery selector for all images, img id as selector for the PCBE image --%>
                      <div class="labelicon"><img src="/images/pcbeserver_small.png${version}" class="pcbeIcon pcbeIconSelect tooltip" id="pcbeServerImg${OGIndex}" title="${res.PCBEServerHint}"/></div>                    
                      <label for="outletName${OGIndex}" class="iconwidth"><span id="outletName${OGIndex}Label" class="italic">${sog.outletLabel}</span>&nbsp;${res.OutletName}</label>
                      <div class="valueEntry">
                        <input
                          type="text"
                          value="<c:out value='${sog.outletName}' />"
                          class="outletSetupInput usascii textinput ui-corner-all editable"
                          name="${OGName}"
                          id="outletName${OGIndex}"
                          maxlength="${sog.maxNameLength}"/>
                      </div>
                    </div>
                  </c:if>
                </c:forEach>
              </div>
            </c:if>
            
            <div id="alertMessageDialog" class="dialog"></div>
    
            <%@ include file="button.jspf" %>
            <%@ include file="shutdownwizardbutton.jspf" %>
    
          </div> <%-- main setup container --%>
          <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}"/>
          <input type="hidden" name="formtokenid" id="formtokenid" value="${formtokenid}"/>
        </form> <%-- outletsetupform --%>
      </c:when>
      <c:otherwise>
        <div id="mainbox"><c:out value="${res.OutletSetupNotSupportedMsg}"/></div>
      </c:otherwise>
    </c:choose>
  </main> <%-- container --%>

  <div id="res">
    <span id="resNavigateAwayMsg">${res.NavigateAwayMsg}</span>
    <span id="resButtonOK">${res.ButtonOK}</span>
    <span id="resPCBESelectionWarningTitle">${res.PCBESelectionWarningTitle}</span>
    <span id="resPCBESelectionWarningMessage">${res.PCBESelectionWarningMessage}</span>
    <span id="resMicroLinkInvalidUSASCIICharacter">${res.MicroLinkInvalidUSASCIICharacter}</span>
  </div>

</body>
</html>