<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<html lang="${localeData.resourcesLocale}">
<c:set var="res" value="${localeData.properties}" />
<c:set var="version" value="?${pcbeSettings.productVersion}" />
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Expires" content="-1">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">

<link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
<link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
<link type="text/css" rel="stylesheet" href="/styles/snmpsettings.min.css${version}">
<script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
<script type="text/javascript" src="/js/jquery.validate.min.js${version}"></script>
<script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
<script type="text/javascript" src="/js/jquery.cluetip.js${version}"></script>
<script type="text/javascript" src="/js/common.js${version}"></script>
<script type="text/javascript" src="/js/snmpsettings.js${version}"></script>
<c:forEach var="jssrc" items="${page.scriptSource}">
  <script type="text/javascript" src="${jssrc}${version}"></script>
</c:forEach>

<title>${page.title}</title>
</head>
<body>
  <%@ include file="banner.jspf"%>
  <%@ include file="menu.jspf"%>
  <main id="contentcontainer">
    <h1 id="pageHeader">${page.header}</h1>

    <%-- holds error message warning --%>
    <div class="ui-corner-all" id="errorcontainer">${res.ErrorBoxMsg}</div>

    <form id="formpageform" action="<c:url value='${page.action}'/>" name="${page.name}" method="post">

      <div class="formdiv" id="mainbox">

        <h2 class="expandable minimized">${res['SNMP.SNMPV1Header']}</h2>
        <div>
          <table class="Section">
            <col></col>
            <col class="SectionLeft"></col>
            <col class="SectionRight"></col>
            <col></col>
            <tr>
              <td class="SectionIndent">&nbsp;</td>
              <td class="SectionLeft">${res['SNMP.SNMPV1Enable']}</td>
              <td class="SectionRight"><input id="SNMPV1Enabled"
                <c:if test="${SNMPV1Enabled}">checked="true"</c:if> name="SNMPV1Enabled" type="checkbox"
                class="checkbox"></td>
              <td height="6">&nbsp;</td>
            </tr>
          </table>

          <div class="ui-widget formdiv" id="V1Profiles">
            <div class="ui-widget" id="v1ProfilesListDiv">
              <div class="ui-widget-header " id="v1ProfilesListHeader">${res['SNMP.Profile']}<a href="#"
                  id="addv1ProfilesBtn">${res['SNMP.ProfileAdd']}</a>
              </div>
              <ul class="ui-widget-content " id="v1ProfilesList">
                <c:forEach var="profile" items="${SNMPV1Profiles}">
                  <li class="v1ProfilesItem ui-widget-content "><span class="v1Profile">${profile.name}</span> <span
                    class="nms">${profile.NMS}</span> <span class="access">${profile.accessType}</span> <a href="#"
                    class="editBtn"></a><a href="#" class="deleteBtn"></a></li>
                </c:forEach>
              </ul>
            </div>
          </div>
        </div>

        <h2 class="expandable minimized">${res['SNMP.SNMPV3Header']}</h2>
        <div>
          <table class="Section">
            <col></col>
            <col class="SectionLeft"></col>
            <col class="SectionRight"></col>
            <col></col>
            <tr>
              <td class="SectionIndent">&nbsp;</td>
              <td class="SectionLeft">${res['SNMP.SNMPV3Enable']}</td>
              <td class="SectionRight"><input id="SNMPV3Enabled"
                <c:if test="${SNMPV3Enabled}">checked="true"</c:if> name="SNMPV3Enabled" type="checkbox"
                class="checkbox"></td>
              <td height="6">&nbsp;</td>
            </tr>
          </table>
          <div class="ui-widget formdiv" id="V3Profiles">
            <div class="ui-widget" id="v3ProfilesListDiv">
              <div class="ui-widget-header " id="v3ProfilesListHeader">${res['SNMP.Profile']}<a href="#"
                  id="addv3ProfilesBtn">${res['SNMP.ProfileAdd']}</a>
              </div>
              <ul class="ui-widget-content " id="v3ProfilesList">

                <c:forEach var="profile" items="${SNMPV3Profiles}">
                  <li class="v3ProfilesItem ui-widget-content "><span class="v3Profile">${profile.name}</span> <span
                    class="authProtocol">${profile.authProt}</span> <span class="authPass">${profile.authPass}</span> <span
                    class="privProtocol">${profile.privProt}</span> <span class="privPass">${profile.privPass}</span> <span
                    class="v3access">${profile.accessType}</span> <a href="#" class="editBtn"></a><a href="#"
                    class="deleteBtn"></a></li>
                </c:forEach>

              </ul>
            </div>
          </div>
        </div>

        <h2 class="expandable minimized">${res['SNMP.SNMPTrapsHeader']}</h2>
        <div>
          <table class="Section">
            <col></col>
            <col class="SectionLeft"></col>
            <col class="SectionRight"></col>
            <col></col>
            <tr>
              <td class="SectionIndent">&nbsp;</td>
              <td class="SectionLeft">${res['SNMP.SNMPTrapsCriticalEvents']}</td>
              <td class="SectionRight"><span id="criticalTrap"><span id="CriticalTrapEnabledBtn"></span></span></td>
              <td height="6">&nbsp;</td>
            </tr>
            <tr>
              <td class="SectionIndent">&nbsp;</td>
              <td class="SectionLeft">${res['SNMP.SNMPTrapsCommsEvents']}</td>
              <td class="SectionRight"><span id="commTrap"><span id="CommTrapEnabledBtn"></span></span></td>
              <td height="6">&nbsp;</td>
            </tr>
          </table>

          <div class="ui-widget formdiv" id="TrapReceivers">
            <div class="ui-widget" id="trapReceiversListDiv">
              <div class="ui-widget-header " id="trapReceiversListHeader">${res['SNMP.SNMPTrapsReceivers']}<a
                  href="#" id="addTrapReceiverBtn">${res['SNMP.SNMPTrapsAddReceiver']}</a>
              </div>

              <ul class="ui-widget-content " id="trapReceiversList">

                <c:forEach var="receiver" items="${SNMPTrapReceivers}">
                  <li class="trapReceiversItem ui-widget-content "><span class="nmsEnable">${receiver.enabled}</span>
                    <span class="nmsIP">${receiver.NMSip}</span> <span class="nmsPort">${receiver.NMSport}</span> <span
                    class="nmsType">${receiver.type}</span> <span class="nmsProfile">${receiver.profile}</span> <a
                    href="#" class="editBtn"></a><a href="#" class="deleteBtn"></a></li>
                </c:forEach>

              </ul>
            </div>
          </div>

        </div>

        <h2 class="expandable minimized">${res['SNMP.SNMPMisc']}</h2>
        <table class="Section">
          <col></col>
          <col class="SectionLeft"></col>
          <col class="SectionRight"></col>
          <col></col>
          <tr>
            <td class="SectionIndent">&nbsp;</td>
            <td class="SectionLeft">${res['SNMP.EngineID']}</td>
            <td class="SectionRight"><input id="EngineID" name="EngineID" size="8" type="text"
              class="text ui-corner-all" autocomplete="off" value="${localEngineID}" readonly></td>
            <td height="6">&nbsp;</td>
          </tr>
          <tr>
            <td class="SectionIndent">&nbsp;</td>
            <td class="SectionLeft">${res['SNMP.DiscoveryPort']}</td>
            <td class="SectionRight"><input id="SNMPPort" maxlength="5" name="SNMPPort" size="6" type="text"
              class="text ui-corner-all" autocomplete="off" value="${discoveryPort}"></td>
            <td height="6">&nbsp;</td>
          </tr>
        </table>
      </div>
      <c:forEach var="hidden" items="${page.hiddenInputs}">
        <input type="hidden" id="${hidden.id}" name="${hidden.name}" value="<c:out value="${hidden.value}"/>"
          <c:if test="${not empty hidden.cssClasses}"> class="${hidden.cssClassesAsString}"</c:if> />
      </c:forEach>
      <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}" /> <input type="hidden"
        name="formtokenid" id="formtokenid" value="${formtokenid}" />
      <%@ include file="button.jspf"%>

    </form>

    <div id="submitdialog" title="${res.SubmitDialogTitle}">
      <p>${res.SubmitDialogContent}</p>
      <p class="waitimg">
        <img src="/styles/images/wait.gif${version}" />
      </p>
    </div>

    <%----------------------------------------------------------%>
    <%-- Divs for the Dialogs.  These are hidden until needed --%>
    <%----------------------------------------------------------%>

    <div id="v1ProfileDialog">
      <form id="v1ProfileForm">
        <div class="labelvaluediv">
          <span class="label"><label for="community">${res['SNMP.SNMPV1Community']}</label></span> <span class="value"><input
            id="community" maxlength="15" name="community" size="17" type="text" class="text ui-corner-all"
            autocomplete="off" value=""></span>
        </div>
        <div class="labelvaluediv">
          <span class="label"><label for="nms">${res['SNMP.NMS']}</label></span> <span class="value"><input
            id="nms" maxlength="64" name="nms" size="66" type="text" class="text ui-corner-all" autocomplete="off"
            value=""></span>
        </div>
        <div class="labelvaluediv">
          <span class="label"><label for="access">${res['SNMP.Access']}</label></span> <span class="value"><select
            name="access" class="dropdown ui-corner-all editable" id="access"><option value="DISABLED">${res['SNMP.Disable']}
              <option value="READONLY">${res['SNMP.Read']}
              <option value="READWRITE">${res['SNMP.Write']}</select></span>
        </div>
        <input id="v1ProfileIndex" name="v1ProfileIndex" type="hidden" class="hidden" value="-1">
      </form>
    </div>

    <div id="v3ProfileDialog">
      <form id="v3ProfileForm">

        <div class="labelvaluediv">
          <span class="label"><label for="v3user">${res['SNMP.SNMPV3User']}</label></span><span class="value"><input
            id="v3user" maxlength="32" name="v3user" size="34" type="text" class="text ui-corner-all" autocomplete="off"
            value=""></span>
        </div>
        <div class="labelvaluediv">
          <span class="label"><label for="authProtocol">${res['SNMP.SNMPV3Auth']}</label></span><span class="value"><select
            name="authProtocol" class="dropdown ui-corner-all editable" id="authProtocol"><option value="NONE">${res['SNMP.None']}
              <option value="MD5">${res['SNMP.MD5']}
              <option value="SHA1">${res['SNMP.SHA1']}
              <option value="SHA256">${res['SNMP.SHA256']}
              <option value="SHA512">${res['SNMP.SHA512']}</select></span>
        </div>
        <div class="labelvaluediv">
          <span class="label"><label for="authPass">${res['SNMP.SNMPV3AuthPass']}</label></span><span class="value"><input
            id="authPass" maxlength="32" name="authPass" size="34" type="password" class="password ui-corner-all"
            autocomplete="off" value=""></span>
        </div>
        <div class="labelvaluediv">
          <span class="label"><label for="privProtocol">${res['SNMP.SNMPV3Priv']}</label></span><span class="value"><select
            name="privProtocol" class="dropdown ui-corner-all editable" id="privProtocol"><option value="NONE">${res['SNMP.None']}
              <option value="AES128">${res['SNMP.AES128']}
              <option value="AES192">${res['SNMP.AES192']}
              <option value="AES192EX">${res['SNMP.AES192EX']}
              <option value="AES256">${res['SNMP.AES256']}
              <option value="AES256EX">${res['SNMP.AES256Ex']}
              <option value="DES">${res['SNMP.DES']}</select></span>
        </div>
        <div class="labelvaluediv">
          <span class="label"><label for="privPass">${res['SNMP.SNMPV3PrivPass']}</label></span><span class="value"><input
            id="privPass" maxlength="32" name="privPass" size="34" type="password" class="password ui-corner-all"
            autocomplete="off" value=""></span>
        </div>
        <div class="labelvaluediv">
          <span class="label"><label for="v3access">${res['SNMP.Access']}</label></span><span class="value"><select
            name="v3access" class="dropdown ui-corner-all editable" id="v3access"><option value="DISABLED">${res['SNMP.Disable']}
              <option value="READONLY">${res['SNMP.Read']}
              <option value="READWRITE">${res['SNMP.Write']}</select></span>
        </div>
        <input id="v3ProfileIndex" name="v3ProfileIndex" type="hidden" class="hidden" value="-1">
      </form>
    </div>


    <div id="trapReceiverDialog">
      <form id="trapReceiverForm">
        <div class="labelvaluediv">
          <span class="label"><label for="nmsEnable">${res['SNMP.Enable']}</label></span><span class="value"><input
            id="nmsEnable" name="nmsEnable" type="checkbox" class="checkbox" value="on"></span>
        </div>
        <div class="labelvaluediv">
          <span class="label"><label for="nmsIP">${res['SNMP.NMS']}</label></span><span class="value"><input
            id="nmsIP" maxlength="64" name="nmsIP" size="66" type="text" class="text ui-corner-all" autocomplete="off"
            value=""></span>
        </div>
        <div class="labelvaluediv">
          <span class="label"><label for="nmsPort">${res['SNMP.Port']}</label></span><span class="value"><input
            id="nmsPort" maxlength="6" name="nmsPort" size="8" type="text" class="text ui-corner-all" autocomplete="off"
            value=""></span>
        </div>
        <div class="labelvaluediv">
          <span class="label"><input id="nmsTypeV1" name="nmsType" type="radio" class="radio" value="V1"><label
            for="nmsTypeV1">${res['SNMP.SNMPV1Header']}</label></span><span class="value"></span>
        </div>
        <div class="labelvaluediv">
          <span class="label"><label for="nmsV1User">${res['SNMP.SNMPV1Community']}</label></span><span class="value"><input
            id="nmsV1User" maxlength="15" name="nmsV1User" size="34" type="text" class="text ui-corner-all"
            autocomplete="off" value=""></span>
        </div>
        <div class="labelvaluediv">
          <span class="label"><input id="nmsTypeV3" checked="checked" name="nmsType" type="radio" class="radio"
            value="V3"><label for="nmsTypeV3">${res['SNMP.SNMPV3Header']}</label></span><span class="value"></span>
        </div>
        <div class="labelvaluediv">
          <span class="label"><label for="nmsV3User">${res['SNMP.SNMPV3User']}</label></span><span class="value"><select
            name="nmsV3User" class="dropdown ui-corner-all editable" id="nmsV3User"></select></span>
        </div>
        <div class="labelvaluediv">
          <span class="label"><input id="testTrap" name="testTrap" type="button" class="newbutton"
            value="${res['SNMP.SNMPTrapsReceiverTest']}"></span><span class="value"><label class="error"
            id="testTrapResult"></label></span>
        </div>
        <input id="trapReceiverIndex" name="trapReceiverIndex" type="hidden" class="hidden" value="-1">
      </form>
    </div>



    <div id="CriticalTrapDialog">
      <form id="CriticalTrapForm">
        <div class="labelvaluediv">
          <span class="label"><label>${res['SNMP.SNMPTrapsName']}</label></span> <span class="value"><label>${res['SNMP.SNMPTrapsCriticalEvents']}</label></span>
        </div>

        <div class="labelvaluediv">
          <span class="label"><label for="trapEnabled">${res['SNMP.Enable']}</label></span> <span class="value">
            <input id="trapEnabled" <c:if test="${UPSCriticalEvents_Enabled}">checked="checked"</c:if>
            name="trapEnabled" type="checkbox" class="checkbox" value="on">
          </span>
        </div>

        <div class="labelvaluediv">
          <span class="label"><label for="trapDelay">${res['SNMP.SNMPTrapsDelay']}</label></span> <span class="value"><input
            id="trapDelay" maxlength="3" name="trapDelay" size="5" type="text" class="text ui-corner-all"
            autocomplete="off" value="${UPSCriticalEvents_Delay}"><span class="unit">${res.SeondsLabelShort}</span></span>
        </div>

        <div class="labelvaluediv">
          <span class="label"><label for="repeatInterval">${res['SNMP.SNMPTrapsRepeat']}</label></span> <span
            class="value"><input id="repeatInterval" maxlength="3" name="repeatInterval" size="5" type="text"
            class="text ui-corner-all" autocomplete="off" value="${UPSCriticalEvents_RepeatInterval}"><span
            class="unit">${res.SeondsLabelShort}</span></span>
        </div>
        <div class="labelvaluediv">
          <span class="label"> <input id="repeatTillClear"
            <c:if test="${UPSCriticalEvents_RepeatUntilCleared}">checked="checked"</c:if> name="repeat" type="radio"
            class="radio" value="repeatTillClear"> <label for="repeatTillClear">${res['SNMP.SNMPTrapsRepeatTillClear']}</label></span>
          <span class="value"></span>
        </div>

        <div class="labelvaluediv">
          <span class="label"> <input id="repeatNTimes"
            <c:if test="${not UPSCriticalEvents_RepeatUntilCleared}">checked="checked"</c:if> name="repeat" type="radio"
            class="radio" value="repeatNTimes"> <label for="repeatNTimes">${res['SNMP.SNMPTrapsRepeatN']}</label>
          </span> <span class="value"> <input id="repeatN" maxlength="3" name="repeatN" type="text"
            class="text ui-corner-all" autocomplete="off" value="${UPSCriticalEvents_RepeatTimes}"> <span
            class="unit">${res['SNMP.Times']}</span>
          </span>
        </div>

        <div class="labelvaluediv">
          <span class="label"><label for="clearingTrap">${res['SNMP.SNMPTrapsClearTrap']}</label></span> <span
            class="value"> <input id="clearingTrap"
            <c:if test="${UPSCriticalEvents_SendClearingTrap}">checked="checked"</c:if> name="clearingTrap"
            type="checkbox" class="checkbox" value="on">
          </span>
        </div>
      </form>
    </div>

    <div id="CommTrapDialog">
      <form id="CommTrapForm">
        <div class="labelvaluediv">
          <span class="label"><label>${res['SNMP.SNMPTrapsName']}</label></span> <span class="value"><label>${res['SNMP.SNMPTrapsCommsEvents']}</label></span>
        </div>

        <div class="labelvaluediv">
          <span class="label"><label for="trapEnabled">${res['SNMP.Enable']}</label></span> <span class="value">
            <input id="trapEnabled" <c:if test="${LostCommsEvents_Enabled}">checked="checked"</c:if> name="trapEnabled"
            type="checkbox" class="checkbox" value="on">
          </span>
        </div>

        <div class="labelvaluediv">
          <span class="label"><label for="trapDelay">${res['SNMP.SNMPTrapsDelay']}</label></span> <span class="value"><input
            id="trapDelay" maxlength="3" name="trapDelay" size="5" type="text" class="text ui-corner-all"
            autocomplete="off" value="${LostCommsEvents_Delay}"><span class="unit">${res.SeondsLabelShort}</span></span>
        </div>
        <div class="labelvaluediv">
          <span class="label"><label for="repeatInterval">${res['SNMP.SNMPTrapsRepeat']}</label></span> <span
            class="value"><input id="repeatInterval" maxlength="3" name="repeatInterval" size="5" type="text"
            class="text ui-corner-all" autocomplete="off" value="${LostCommsEvents_RepeatInterval}"><span
            class="unit">${res.SeondsLabelShort}</span></span>
        </div>

        <div class="labelvaluediv">
          <span class="label"> <input id="repeatTillClear"
            <c:if test="${LostCommsEvents_RepeatUntilCleared}">checked="checked"</c:if> name="repeat" type="radio"
            class="radio" value="repeatTillClear"> <label for="repeatTillClear">${res['SNMP.SNMPTrapsRepeatTillClear']}</label>
          </span> <span class="value"></span>
        </div>

        <div class="labelvaluediv">
          <span class="label"> <input id="repeatNTimes"
            <c:if test="${not LostCommsEvents_RepeatUntilCleared}">checked="checked"</c:if> name="repeat" type="radio"
            class="radio" value="repeatNTimes"> <label for="repeatNTimes">${res['SNMP.SNMPTrapsRepeatN']}</label>
          </span> <span class="value"> <input id="repeatN" maxlength="3" name="repeatN" type="text"
            class="text ui-corner-all" autocomplete="off" value="${LostCommsEvents_RepeatTimes}"> <span
            class="unit">${res['SNMP.Times']}</span>
          </span>
        </div>

        <div class="labelvaluediv">
          <span class="label"><label for="clearingTrap">${res['SNMP.SNMPTrapsClearTrap']}</label></span> <span
            class="value"> <input id="clearingTrap"
            <c:if test="${LostCommsEvents_SendClearingTrap}">checked="checked"</c:if> name="clearingTrap"
            type="checkbox" class="checkbox" value="on">
          </span>
        </div>
      </form>
    </div>

    <div id="jsres">
      <span id="resRequiredFieldValidation">${res['FieldRequired']}</span> <span id="resRangeValidation">${res['SNMP.RangeValidation']}</span>
      <span id="resInvalidIPAddress">${res['SNMP.NMSAddressInvalid']}</span> <span id="resInvalidPassword">${res['SNMP.PasswordLengthInvalid']}</span>
      <span id="resInvalidPasswordLong">${res['SNMP.PasswordLengthInvalidLong']}</span> <span id="resUnique">${res['SNMP.Unique']}</span>
      <span id="resPortInUse">${res['SNMP.PortInUse']}</span> <span id="resOKButton">${res.ButtonOK}</span> <span
        id="resCancelButton">${res.ButtonCancel}</span> <span id="resProfileDialogTitle">${res['SNMP.Profile']}</span> <span
        id="resTrapDialogTitle">${res['SNMP.SNMPTrapsConfigureTrap']}</span> <span id="resTrapReceiverDialogTitle">${res['SNMP.SNMPTrapsReceiverConfig']}</span>
      <span id="resTrapTestFail">${res['SNMP.SNMPTrapsReceiverTestFail']}</span> <span id="resTrapTestSuccess">${res['SNMP.SNMPTrapsReceiverTestSuccess']}</span>
    </div>

  </main>
  <%-- End of container --%>
  <div id="res">
    <span id="resNavigateAwayMsg">${res.NavigateAwayMsg}</span> <span id="resErrorLoadingMsg">${res.ErrorLoadingMsg}</span>
  </div>
</body>
</html>