<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<html lang="${localeData.resourcesLocale}">
<c:set var="res" value="${localeData.properties}" />
<c:set var="version" value="?${pcbeSettings.productVersion}"/>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="Expires" content="-1">
  <meta http-equiv="Pragma" content="no-cache">
  <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
  <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
  <link type="text/css" rel="stylesheet" href="/styles/jquery.cluetip.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/batteryframemanagement.min.css${version}">
  <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
  <script type="text/javascript" src="/js/jquery.validate.min.js${version}"></script>
  <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>  
  <script type="text/javascript" src="/js/common.js${version}"></script>
  <script type="text/javascript" src="/js/batteryframemanagement.js${version}"></script>
  <script type="text/javascript" src="/js/jquery.cluetip.js${version}"></script>
  <c:forEach var="jssrc" items="${page.scriptSource}">
    <script type="text/javascript" src="${jssrc}${version}"></script>
  </c:forEach>
  <title>${page.title}</title>
</head>
<body>
  <%@ include file="banner.jspf" %>
  <%@ include file="menu.jspf" %>
  <main id="contentcontainer">
    <h1 id="pageHeader">${page.header}</h1>
    
    <%-- holds error message warning --%>
    <div class="ui-corner-all" id="errorcontainer">
        ${res.ErrorBoxMsg}
    </div>

    <form id="formpageform" action="<c:url value='${page.action}'/>" name="${page.name}" method="post">
      
    <div id="mainbox">
      
        <%-- BATTERY STATUS SECTION --%>
        <h2 class="expandable">${res.BatteryStatusSubHeader}</h2>
          
        <div class="label-value-group">
            <%-- currently only status lvps are stored in page bean --%>
            <c:forEach var="lvp" items="${page.labelValuePairs}" varStatus="vs">
                            
                <div class="label-value-pair">
                    
                    <%-- display label --%>
                    <label>${lvp.label}</label>
                    
                    <%-- display value depending on type --%>
                    <c:forEach var="lvpvalue" items="${lvp.values}">
                    
                       <div id="${lvpvalue.id}" class="value <c:if test="${not empty lvpvalue.cssClasses}">${lvpvalue.cssClassesAsString}</c:if>"><c:out value="${lvpvalue.value}"/></div>
    
                       <c:if test="${not empty lvpvalue.unit}">
                          <div class="unit">${lvpvalue.unit}</div>
                       </c:if>
                        
                    </c:forEach>
                </div>
            </c:forEach>

        </div> 
        <%-- END OF BATTERY STATUS SECTION --%>
        
        
        <%-- PREDICTIVE BATTERY REPLACEMENT  or BATTERY REPLACEMENT SECTION  --%> 
        <c:if test="${not empty predictiveBatteryReplacementUIModel and predictiveBatteryReplacementUIModel.populated}">
        
            <h2 class="expandable">
                 <c:choose>
                    <c:when test="${not empty predictiveBatteryReplacementUIModel.batteryReplacementDateLVP}">
                        ${res.BatteryPredictiveReplacementSubHeader}
                    </c:when>
                    <c:otherwise>
                        ${res.BatteryReplacementSubHeader}
                    </c:otherwise>
                 </c:choose>
            </h2>
            
            <div class="label-value-group">
            
                <%-- BATTERY INSTALLATION DATE --%>
                <c:if test="${not empty predictiveBatteryReplacementUIModel.batteryInstallationDateLVP}">
                
                    <%-- set JSP variable to hold LVP to send to fragment --%>
                    <c:set var="batteryInstallationDateLVP" value="${predictiveBatteryReplacementUIModel.batteryInstallationDateLVP}"/>
                    <%@ include file="batteryinstalldate.jspf" %>
                   
                   <%-- hidden inputs for predictiveBatteryReplacementUIModel to hold 'old' values --%>
                    <c:forEach var="hidden" items="${predictiveBatteryReplacementUIModel.hiddenInputs}">
                        <input type="hidden" id="${hidden.id}" name="${hidden.name}" value="<c:out value="${hidden.value}"/>" />
                    </c:forEach>
                </c:if>
            
        
                <%-- BATTERY REPLACEMENT DATE --%>
                <c:if test="${not empty predictiveBatteryReplacementUIModel.batteryReplacementDateLVP}">
                    <div class="label-value-pair">
                      
                      <%-- display label --%>
                      <label>${predictiveBatteryReplacementUIModel.batteryReplacementDateLVP.label}</label>
                      
                       <%-- will only ever be one value for each LVP, so can hard code 'values' index --%>
                       <c:set var="batteryReplacementDateValue" value="${predictiveBatteryReplacementUIModel.batteryReplacementDateLVP.values[0]}"/>
                       <div id="${predictiveBatteryReplacementUIModel.batteryReplacementDateLVP.id}" class="value <c:if test="${not empty batteryReplacementDateValue.cssClasses}">${batteryReplacementDateValue.cssClassesAsString}</c:if>"><c:out value="${batteryReplacementDateValue.value}"/></div>

                   </div>
                </c:if>
                
                <%-- BATTERY SKU AND REORDER LINK --%>
                <c:if test="${!isHideReorderLink && !predictiveBatteryReplacementUIModel.frameBased && (not empty predictiveBatteryReplacementUIModel.internalRBCSKU || not empty predictiveBatteryReplacementUIModel.internalRBCURL)}">

                    <div class="label-value-pair">
                         <label>${res.RBC}</label>
        
                          <c:if test="${not empty predictiveBatteryReplacementUIModel.internalRBCSKU}">
                              <div class="value fixedWidthSmall"><c:out value="${predictiveBatteryReplacementUIModel.internalRBCSKU}"/></div>
                          </c:if>
                          
                         <div class="value <c:if test="${not empty predictiveBatteryReplacementUIModel.internalRBCSKU}">paddedValueLeft</c:if>"><a href="<c:out value="${predictiveBatteryReplacementUIModel.internalRBCURL}"/>" target="_new"><c:out value="${res.BatteryReorder}"/></a></div>           
                    </div>

                </c:if>
          </div>

        </c:if>
        <%-- END OF PREDICTIVE BATTERY REPLACEMENT SECTION --%> 


        <%-- INTERNAL BATTERY SECTION --%> 
        <c:if test="${not empty internalBatteryModuleUIModels}">
        
            <h2 class="expandable minimized">${res.BatteryInternalPacksSubHeader}</h2>
        
            <%-- frame based systems will have nested groups --%> 
	        <c:if test="${not empty predictiveBatteryReplacementUIModel and predictiveBatteryReplacementUIModel.frameBased}">
	           <div class="label-value-group">
	        </c:if>
        
	            <c:set var="batteryModuleUIModels" value="${internalBatteryModuleUIModels}"/>
	            <%@ include file="batterymodule.jspf" %>
            
            <c:if test="${not empty predictiveBatteryReplacementUIModel and predictiveBatteryReplacementUIModel.frameBased}">
               </div>
            </c:if>

        </c:if>
        <%-- END OF INTERNAL BATTERY PACKS SECTION --%> 


        <%-- EXTERNAL/GENERIC BATTERY SECTION --%> 
        <c:if test="${not empty externalBatteryModuleUIModels}">
        
            <h2 class="expandable minimized">${res.BatteryPacksSubHeader}</h2>
        
            <%-- frame based systems will have nested groups --%> 
            <c:if test="${not empty predictiveBatteryReplacementUIModel and predictiveBatteryReplacementUIModel.frameBased}">
               <div class="label-value-group">
            </c:if>
        
	            <c:set var="batteryModuleUIModels" value="${externalBatteryModuleUIModels}"/>
	            <%@ include file="batterymodule.jspf" %>
	            
	        <c:if test="${not empty predictiveBatteryReplacementUIModel and predictiveBatteryReplacementUIModel.frameBased}">
               </div>
            </c:if>
          
        </c:if>
        <%-- END OF EXTERNAL/GENERIC BATTERY PACKS SECTION --%> 
                
        <%-- ORDER BATTERY PARTS SECTION (ClubAPC/OEM customers have their own reorder mechanism) --%>
        <c:if test="${!isHideReorderLink && predictiveBatteryReplacementUIModel.frameBased && (not empty predictiveBatteryReplacementUIModel.internalRBCSKU || not empty predictiveBatteryReplacementUIModel.internalRBCURL)}">
            <h2 class="expandable minimized">${res.OrderBatteryPartsSubHeader}</h2>
                    
            <div class="label-value-group">
                <div class="label-value-pair">
                     <label>${res.RBC}</label>
    
                     <div class="value fixedWidthSmall"><c:out value="${predictiveBatteryReplacementUIModel.internalRBCSKU}"/></div>
                      
                     <div class="value paddedValueLeft"><a href="<c:out value="${predictiveBatteryReplacementUIModel.internalRBCURL}"/>" target="_new"><c:out value="${res.BatteryReorder}"/></a></div>           
                </div>
            </div>
        </c:if>
  
      </div>  <%-- END OF MAIN BOX --%> 
      
      <c:forEach var="hidden" items="${page.hiddenInputs}">
        <input type="hidden" id="${hidden.id}" name="${hidden.name}" value="<c:out value="${hidden.value}"/>" <c:if test="${not empty hidden.cssClasses}"> class="${hidden.cssClassesAsString}"</c:if>/>
      </c:forEach>
      <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}"/>
      <input type="hidden" name="formtokenid" id="formtokenid" value="${formtokenid}"/>
      <%@ include file="button.jspf" %>
    </form>
    <div id="submitdialog" title="${res.SubmitDialogTitle}">
        <p>${res.SubmitDialogContent}</p>
        <p class="waitimg"><img src="/styles/images/wait.gif${version}"/></p>
    </div>
   
  </main>  <%-- END OF CONTENT CONTAINER --%>
  <div id="res">
    <span id="manufactureMonth">${upsDateUIModel.manuMonth}</span>
    <span id="manufactureYear">${upsDateUIModel.manuYear}</span>    
    <span id="yearNow">${upsDateUIModel.yearNow}</span>
    <span id="monthNow">${upsDateUIModel.monthNow}</span>
    <span id="resNavigateAwayMsg">${res.NavigateAwayMsg}</span>
    <span id="images"><img src="styles/cupertino/images/ui-icons_ffffff_256x240.png${version}"><img src="styles/cupertino/images/ui-icons_222222_256x240.png${version}"></span>
  </div>
</body>
</html>