<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<html lang="${localeData.resourcesLocale}">
  <c:set var="res" value="${localeData.properties}" />
  <c:set var="version" value="?${pcbeSettings.productVersion}"/>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="Expires" content="-1">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
    <link type="text/css" rel="stylesheet" href="/styles/jquery.cluetip.min.css${version}">
    <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
    <link type="text/css" rel="stylesheet" href="/styles/pcbe-jquery-ui-overrides.min.css${version}">
    <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
    <link type="text/css" rel="stylesheet" href="/styles/error.min.css${version}">
    <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
    <script type="text/javascript" src="/js/jquery.cluetip.js${version}"></script>
    <script type="text/javascript" src="/js/jquery.validate.min.js${version}"></script>
    <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
    <script type="text/javascript" src="/js/common.js${version}"></script>
    <title>${page.title}</title>
  </head>
  <body>
    <%@ include file="banner.jspf" %>
    <%@ include file="menu.jspf" %>
    <main id="contentcontainer">
      <h1 id="pageHeader">${page.header}</h1>
      <div id="mainbox">
        <c:choose>
          <c:when test="${not empty commslost}">
            <h4>${res.DeviceCommunicationsLostMsg}</h4>
          </c:when>
          <c:when test="${code==401}">
            <h4>${res.AuthenticationFailedMsg}</h4>
          </c:when>
          <c:when test="${code==404}">
            <h4>${res.UnsupportedURL}</h4>
          </c:when>
          <c:when test="${not empty endDateStartDateException}">
             <div><p>${res.EndDateStartDateExceptionText1}</p></div>
             <div><p>${res.EndDateStartDateExceptionText2}</p></div>
          </c:when>
          <c:when test="${not empty sytemPcbeInstallDateException}">
            <div><p>${res.SytemPcbeInstallDateExceptionText1}</p></div>
            <div><p>${res.EndDateStartDateExceptionText2}</p></div>
          </c:when>
          <c:otherwise>            
            <h4>${res.GeneralErrorHeader}</h4>
          </c:otherwise>
        </c:choose>
        <div id="homepagelink">
          <a href="<c:url value='/'/>">${res.BackToHomePageLink}</a>
        </div>
      </div>
    </main>
  </body>
</html>