<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<html lang="${localeData.resourcesLocale}">
<c:set var="res" value="${localeData.properties}" />
<c:set var="version" value="?${pcbeSettings.productVersion}"/>
<head>

  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="Expires" content="-1">
  <meta http-equiv="Pragma" content="no-cache">
  <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">

  <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
  <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/jquery.cluetip.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/demo_page.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/demo_table.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/demo_table_jui.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/datalog.min.css${version}">

  <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
  <script type="text/javascript" src="/js/jquery.validate.min.js${version}"></script>
  <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
  <script type="text/javascript" src="/js/common.js${version}"></script>
  <script type="text/javascript" src="/js/jquery.cluetip.js${version}"></script>
  <script type="text/javascript" src="/js/jquery.dataTables.min.js${version}"></script>  
  <script type="text/javascript" src="/js/eventlog.js${version}"></script>

  <title>${page.title}</title>
</head>
<body>
  <%@ include file="banner.jspf" %>
  <%@ include file="menu.jspf" %>
  <main id="contentcontainer">
    <h1 id="pageHeader">${page.header}</h1>
    
    <%-- holds error message warning --%>
    <div class="ui-corner-all" id="errorcontainer">
        ${res.ErrorBoxMsg}
    </div>
    
    <form id="formpageform" action="<c:url value='${page.action}'/>" name="${page.name}" method="post">
      <div id="mainbox">
        
        <%--  Warn the user if event logging is disabled --%>
        <c:if test="${eventLoggingConfigured eq false}">
        <div class="label-value-pair">
          <div id="eventLoggingConfigure" class="valueEntry">
            <span>
            <div class="value">${res.EventLoggingDisabled}&nbsp;</div>
            <div class="value"><a href="${logsettingsurl}">${res.ClickHereToConfigure}</a></div>
            </span>
          </div>
        </div>
        </c:if>
        
        <br/>
    
        <div>
           <%-- JQuery Datatables will do the work of rendering the table data.
                See eventlog.js  --%>
           <table id="eventlog" name="eventlog">
              <thead>
                 <tr>
                    <th id="dateTh">${res.DateHeader}</th>
                    <th id="timeTh">${res.TimeHeader}</th>
                    <th id="eventTh">${res.EventHeader}</th>
                </tr>
              </thead>
              <tbody>
              </tbody>
           </table>
        </div>
        
        <br/>
        <br/>
        
        <div id="button-bar">
          <input type="button" value="${res.ButtonExport}" class="button" id="export" name="export"/>
          <input type="submit" value="${res.ButtonClearLog}" class="button" id="clear" name="clear"/>
          <input type="button" value="${res.ButtonRefresh}" class="button" id="refresh" name="refresh" onClick="updateTable();"/>
        </div>

      </div> <%-- End of mainbox --%>
      <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}"/>
      <input type="hidden" name="formtokenid" id="formtokenid" value="${formtokenid}"/>
    </form>
  </main><%-- End of container --%>
  <div id="res">
    <span id="resButtonClearLog">${res.ButtonClearLog}</span>
    <span id="resEventLoggingConfigured">${eventLoggingConfigured}</span>
    <span id="resClearEventLogConfirmation">${res.ClearEventLogConfirmation}</span>
    <span id="resAgentRebootLogin">${res.AgentRebootLogin}</span>
    <span id="resEventLogParseError">${res.EventLogParseError}</span>
    <span id="resExportDialogTitle">${res['EventLog.ExportDialogTitle']}</span>
    <span id="resExportDialogSuccessMsg">${res['EventLog.ExportDialogMsgSuccess']}</span>
    <span id="resExportDialogErrorMsg">${res['EventLog.ExportDialogMsgError']}</span>
    <%-- JQuery DataTables Internationalisation/Localisation --%>
    <span id="ressLengthMenu">${res.sLengthMenu}</span>
    <span id="ressZeroRecords">${res.sZeroRecords}</span>
    <span id="ressInfo">${res.sInfo}</span>
    <span id="ressInfoEmpty">${res.sInfoEmpty}</span>
    <span id="ressEmptyTable">${res.sEmptyTable}</span>
    <span id="ressLoadingRecords">${res.sLoadingRecords}</span>
    <span id="ressProcessing">${res.sProcessing}</span>
    <span id="ressFirst">${res.sFirst}</span>
    <span id="ressLast">${res.sLast}</span>
    <span id="ressNext">${res.sNext}</span>
    <span id="ressPrevious">${res.sPrevious}</span>
  </div>
  <div id="ajaxEventLogURL" class="hidden"><c:url value="/ajaxeventlog"/></div>
  <div id="ajaxEventLogExportURL" class="hidden"><c:url value="/ajaxeventlogexport"/></div>
</body>
</html>