<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<html lang="${localeData.resourcesLocale}">
<c:set var="res" value="${localeData.properties}" />
<c:set var="version" value="?${pcbeSettings.productVersion}"/>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="Expires" content="-1">
  <meta http-equiv="Pragma" content="no-cache">
  <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
  <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
  <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/jquery.cluetip.min.css${version}">
  <c:forEach var="csshref" items="${page.css}">
    <link type="text/css" rel="stylesheet" href="${csshref}${version}">
  </c:forEach>
  <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
  <script type="text/javascript" src="/js/jquery.validate.min.js${version}"></script>
  <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
  <script type="text/javascript" src="/js/common.js${version}"></script>
  <script type="text/javascript" src="/js/jquery.cluetip.js${version}"></script>
  <c:forEach var="script" items="${page.script}">
    <script type="text/javascript">${script}</script>
  </c:forEach>
  <c:forEach var="jssrc" items="${page.scriptSource}">
    <script type="text/javascript" src="${jssrc}${version}"></script>
  </c:forEach>
  <title>${page.title}</title>
</head>
<body>
  <%@ include file="banner.jspf" %>
  <%@ include file="menu.jspf" %>
  <main id="contentcontainer">
    <h1 id="pageHeader">${page.header}</h1>
    
    <%-- holds error message warning --%>
    <div class="ui-corner-all" id="errorcontainer">
        ${res.ErrorBoxMsg}
    </div>
    
    <c:choose>
      <c:when test="${not empty page.id}">
        <c:set var="pageId" value="${page.id}"/>
      </c:when>
      <c:otherwise>
        <c:set var="pageId" value="formpageform"/>
      </c:otherwise>
    </c:choose>
    <form id="${pageId}" action="<c:url value='${page.action}'/>" name="${page.name}" method="post">
      <div id="mainbox">
      
        <%-- loop thru all label value pairs for this page --%>
        <c:forEach var="lvp" items="${page.labelValuePairs}" varStatus="vs">
          <c:if test="${not empty lvp.subHeader}">
          
            <%-- if not first subheader we close off the label-value-group div below --%>
            <c:if test="${not vs.first}"></div></c:if>
            
            <%-- create a new subheader and start a label-value-group div for its associated label value pairs --%>
            <h2<c:if test="${not empty lvp.cssClasses}"> class="${lvp.cssClassesAsString}"</c:if><c:if test="${not empty lvp.tooltip}"> title="${lvp.tooltip}"</c:if>>${lvp.subHeader}</h2>
            <div class="label-value-group ui-corner-all">
          </c:if>
          
          <%-- lvps can be wrapped inside a div by adding a start div id to the first lvp inside, and an end div to the last --%>
          <c:if test="${not empty lvp.startDivGroupClasses}"> <div <c:if test="${not empty lvp.startDivGroupTitle}">title="${lvp.startDivGroupTitle}"</c:if> class="${lvp.startDivGroupClasses}"></c:if>
          
          <div class="label-value-pair"<c:if test="${not empty lvp.id}"> id="${lvp.id}"</c:if>>
            <%-- display label icon if there is one --%>
            <c:if test="${not empty lvp.labelIcon}"><img class="labelicon" src="${lvp.labelIcon}"></c:if>
            
            <%-- display label --%>
            <c:if test="${not empty lvp.label}"><label<c:if test="${not empty lvp.linkedValueId}"> for="${lvp.linkedValueId}"</c:if>>${lvp.label}</label></c:if>
            
            <%-- display value depending on type --%>
            <c:forEach var="lvpvalue" items="${lvp.values}">
              <div class="valueEntry">
                <c:choose>
                  <c:when test="${lvpvalue.stringValue}">
                    <div <c:if test="${not empty lvpvalue.id}">id="${lvpvalue.id}" </c:if>class="value<c:if test="${not empty lvpvalue.cssClasses}"> ${lvpvalue.cssClassesAsString}</c:if>"><c:out value="${lvpvalue.value}"/></div>
                  </c:when>
                  <c:when test="${lvpvalue.hyperlinkValue}">
                    <a href="<c:out value='${lvpvalue.href}'/>" target="_blank"><c:out value="${lvpvalue.value}"/></a>
                  </c:when>
                  <c:when test="${lvpvalue.inputValue}">
                    <input type="${lvpvalue.inputType}"
                      id="${lvpvalue.id}"
                      name="${lvpvalue.name}"
                      maxlength="${lvpvalue.maxLength}"
                      minlength="${lvpvalue.minLength}"
                      <c:if test="${not empty lvpvalue.maxValue}">max="${lvpvalue.maxValue}"</c:if>
                      <c:if test="${not empty lvpvalue.minValue}">min="${lvpvalue.minValue}"</c:if>
                      <c:if test="${lvpvalue.size > 0}">size="${lvpvalue.size}"</c:if>
                      <c:if test="${lvpvalue.readOnly}">readonly="readonly"</c:if>
                      <c:if test="${lvpvalue.inputType eq 'password'}">autocomplete="off"</c:if>
                      <c:if test="${not empty lvpvalue.tooltip}">title="${lvpvalue.tooltip}"</c:if>
                      <%-- get from InputValue if required any validation classes (see common.js for classes) --%>
                      class="textinput ui-corner-all <c:if test="${not empty lvpvalue.cssClasses}">${lvpvalue.cssClassesAsString}</c:if>"
                      value="<c:out value="${lvpvalue.value}"/>"/>
                  </c:when>
                  <c:when test="${lvpvalue.selectValue}">
                    <c:set var="selectedIndex" value="${lvpvalue.selectedIndex}"/>
                    <select id="${lvpvalue.id}" 
                        name="${lvpvalue.name}" 
                        size="1"
                        <c:if test="${lvpvalue.readOnly}">disabled="disabled"</c:if> 
                        class="dropdown ui-corner-all <c:if test="${not empty lvpvalue.cssClasses}">${lvpvalue.cssClassesAsString}</c:if>">
                      <c:choose>
                        <c:when test="${lvpvalue.selectValueIntegerRange}">
                          <c:forEach var="optionValue" begin="${lvpvalue.minValue}" end="${lvpvalue.maxValue}" step="${lvpvalue.stepSize}" varStatus="option" >
                            <c:choose>
                              <c:when test="${selectedIndex == option.index}">
                                <option value="${optionValue}" selected="selected"><c:out value="${optionValue}"/></option>
                              </c:when>
                              <c:otherwise>
                                <option value="${optionValue}"><c:out value="${optionValue}"/></option>
                              </c:otherwise>
                            </c:choose>
                          </c:forEach>
                        </c:when>
                        <c:otherwise>
  	                      <c:forEach var="selectOption" items="${lvpvalue.optionList}" varStatus="option">
  	                        <c:choose>
  	                          <c:when test="${selectedIndex == option.index}">
  	                            <option value="${selectOption.value}" selected="selected"><c:out value="${selectOption.displayValue}"/></option>
  	                          </c:when>
  	                          <c:otherwise>
                                <c:if test="${selectOption.disabled eq true}">
                                    <option value="${selectOption.value}" disabled><c:out value="${selectOption.displayValue}"/></option>
                                </c:if>
                                <c:if test="${selectOption.disabled eq false}">
                                  <option value="${selectOption.value}"><c:out value="${selectOption.displayValue}"/></option>
                                </c:if>
  	                          </c:otherwise>
  	                        </c:choose>
  	                      </c:forEach>
                        </c:otherwise>
                      </c:choose>
                    </select>
					<c:if test="${lvpvalue.id == 'new_value_countries'}">
					    <div id="defaults">
					        <c:forEach var="country" items="${lvpvalue.energyUsageCountryList}" varStatus="vs">
					          <div id="${country.countryCode}">
					            <span class="cost">${country.defaultCostKWh}</span>
					            <span class="co2">${country.defaultCO2EmissionKWh}</span>
					            <span class="currencyCode">${country.currencyCode}</span>
                                <span class="currencySymbol">${country.currencySymbol}</span>
					          </div>
					        </c:forEach>
					    </div>                      
					</c:if>
                  </c:when>
                  <c:when test="${lvpvalue.checkBoxValue}">
                    <input type="checkbox"
                      id="${lvpvalue.id}"
                      name="${lvpvalue.name}"
                      <c:if test="${lvpvalue.readOnly}">readonly="readonly"</c:if>
                      <c:if test="${lvpvalue.checked}">checked="checked"</c:if>
                      <%-- get from CheckBoxValue if required, and any validation classes (see common.js for classes) --%>
                      class="checkbox ui-corner-all <c:if test="${not empty lvpvalue.cssClasses}">${lvpvalue.cssClassesAsString}</c:if>"
                      value="<c:out value="${lvpvalue.value}"/>" />
                  </c:when>
                  <c:when test="${lvpvalue.radioButtonValue}">
                    <input type="radio"
                      id="${lvpvalue.id}"
                      name="${lvpvalue.name}"
                      <c:if test="${lvpvalue.readOnly}">readonly="readonly"</c:if>
                      <c:if test="${lvpvalue.checked}">checked="checked"</c:if>
                      <%-- get from RadioButtonValue if required, and any validation classes (see common.js for classes) --%>
                      class="radio ui-corner-all <c:if test="${not empty lvpvalue.cssClasses}">${lvpvalue.cssClassesAsString}</c:if>"
                      value="<c:out value="${lvpvalue.value}"/>" />
                  </c:when>
                  <c:when test="${lvpvalue.tableValue}">
	  			      <table id="${lvpvalue.id}"></table>
					  <div id="${lvpvalue.divId}"></div>
                  </c:when>
                  
                  <c:when test="${lvpvalue.minutesSecondsValue}">
                    
                    <input type="${lvpvalue.inputType}"
                      id="${lvpvalue.minsId}"
                      name="${lvpvalue.minsName}"
                      maxlength="2"
                      minlength="1"
                      max="59"
                      min="0"
                      size="2"
                      <c:if test="${not empty lvpvalue.tooltip}">title="${lvpvalue.tooltip}"</c:if>
                      <%-- get from InputValue if required any validation classes (see common.js for classes) --%>
                      class="textinput ui-corner-all mins required editable <c:if test="${not empty lvpvalue.cssClasses}">${lvpvalue.cssClassesAsString}</c:if>"
                      value="<c:out value="${lvpvalue.minutes}"/>"/>
                    
                    <div class="unit">{res.MinsSecsSpacer}</div>
                    
                    <input type="${lvpvalue.inputType}"
                      id="${lvpvalue.secsId}"
                      name="${lvpvalue.secsName}"
                      maxlength="2"
                      minlength="1"
                      max="59"
                      min="0"
                      size="2"
                      <c:if test="${not empty lvpvalue.tooltip}">title="${lvpvalue.tooltip}"</c:if>
                      <%-- get from InputValue if required any validation classes (see common.js for classes) --%>
                      class="textinput ui-corner-all secs required editable <c:if test="${not empty lvpvalue.cssClasses}">${lvpvalue.cssClassesAsString}</c:if>"
                      value="<c:out value="${lvpvalue.seconds}"/>"/>

                  </c:when>
                  
                </c:choose>
                <c:if test="${not empty lvpvalue.unit}">
                  <div class="unit">${lvpvalue.unit}</div>
                </c:if>
              </div>
            </c:forEach>
          </div>
          
          <%-- lvps can be wrapped inside a div by adding a start div id to the first lvp inside, and an end div to the last --%>
          <c:if test="${lvp.endDivGroup}"></div></c:if>
          
          <c:if test="${vs.last}"></div></c:if>
        </c:forEach>
        <c:forEach var="hidden" items="${page.hiddenInputs}">
          <input type="hidden" id="${hidden.id}" name="${hidden.name}" value="<c:out value="${hidden.value}"/>" <c:if test="${not empty hidden.cssClasses}"> class="${hidden.cssClassesAsString}"</c:if>/>
        </c:forEach>
        <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}"/>
        <input type="hidden" name="formtokenid" id="formtokenid" value="${formtokenid}"/>
        <%@ include file="button.jspf" %>
      </div>
    </form>
    
    <c:if test="${displaySubmitDialog}">
	    <div id="submitdialog" title="${res.SubmitDialogTitle}">
	      <p>${res.SubmitDialogContent}</p>
	      <p class="waitimg"><img src="/styles/images/wait.gif${version}" /></p>
	    </div>
    </c:if>
    
  </main><%-- End of container --%>
  <c:forEach var="dialog" items="${page.dialogs}">
    <div id="${dialog.id}" class="dialog" title="${dialog.title}">
      <div class="dialogMessage"><c:out value="${dialog.message}"/></div>
      <%-- TODO: button bar implementation, loop over dialog.buttons for the button bar. --%>
    </div>
  </c:forEach>
  <div id="res">
    <span id="resRequiredError">${res.FieldRequired}</span>
    <span id="resNotANumberError">${res.NotANumberError}</span>
    <span id="resNotADecimalNumberError">${res.NotADecimalNumberError}</span>
    <span id="resMicroLinkInvalidAlphaNumCharacter"><c:out value="${res.MicroLinkInvalidAlphaNumCharacter}"/></span>   
    <span id="resMicroLinkInvalidUSASCIICharacter">${res.MicroLinkInvalidUSASCIICharacter}</span>
    <span id="resErrorCrossSiteScripting">${res.ErrorCrossSiteScripting}</span>
    <span id="resInvalidTimeFormat">${res.InvalidTimeFormat}</span>
    <span id="resStartEndTimesSame">${res.StartEndTimesSame}</span>
    <span id="resInvalidMinsFormat">${res.MinsError}</span>
    <span id="resInvalidSecsFormat">${res.SecsError}</span>
    <span id="resNavigateAwayMsg">${res.NavigateAwayMsg}</span>
    <span id="resErrorBoxMsg">${res.ErrorBoxMsg}</span>
    <span id="resYes">${res.Yes}</span>
    <span id="resNo">${res.No}</span>
    <span id="images"><img src="styles/cupertino/images/ui-icons_ffffff_256x240.png"><img src="styles/cupertino/images/ui-icons_222222_256x240.png"></span>

    <c:forEach var="page_attribute" items="${page.attributes}">
    <span id="${page_attribute.key}">${page_attribute.value}</span>
  	</c:forEach>

  </div>
</body>
</html>