<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<html lang="${localeData.resourcesLocale}">
<c:set var="res" value="${localeData.properties}" />
<c:set var="version" value="?${pcbeSettings.productVersion}"/>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="Expires" content="-1">
  <meta http-equiv="Pragma" content="no-cache">
  <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
  <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
  <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/jquery.cluetip.min.css${version}">

  <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
  <script type="text/javascript" src="/js/jquery.validate.min.js${version}"></script>
  <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
  <script type="text/javascript" src="/js/common.js${version}"></script>
  <script type="text/javascript" src="/js/jquery.cluetip.js${version}"></script>
  <script type="text/javascript" src="/js/logsettings.js${version}"></script>
  <c:forEach var="jssrc" items="${page.scriptSource}">
    <script type="text/javascript" src="${jssrc}${version}"></script>
  </c:forEach>

  <title>${page.title}</title>
</head>
<body>
  <%@ include file="banner.jspf" %>
  <%@ include file="menu.jspf" %>
  <main id="contentcontainer">
    
    <h1 id="logSettings">${res.LogSettings}</h1>
    
    <%-- holds error message warning --%>
    <div class="ui-corner-all" id="errorcontainer">
        ${res.ErrorBoxMsg}
    </div>
    
    <form id="formpageform" action="<c:url value='${page.action}'/>" name="${page.name}" method="post">
      <div id="mainbox">
      
        <h2>${res.EventLogConfigurationHeader}</h2>
        
        <div class="label-value-group ui-corner-all">
        
        <div class="label-value-pair">
          <div class="valueEntry">
            <div id="value_EventLogInstruction" class="value">${res.EventLogInstruction}</div>
          </div>
        </div>
        
        <div class="label-value-pair">
          <label for="new_value_eventloggingEnabledCheckBox">${res.EnableEventLogging}</label>
          <div class="valueEntry">
             <input type="checkbox"
                    id="new_value_eventloggingEnabledCheckBox"
                    name="new_value_eventloggingEnabledCheckBox"
                    <c:if test="${eventLoggingEnabled}">checked="checked"</c:if>                    
                    class="checkbox ui-corner-all jquerycheckbox editable"
                    value="" />
          </div>
        </div>
        
        <div class="label-value-pair">
          <label>${res.EventLogExpiration}</label>
          <div class="valueEntry">
            <select id="new_value_eventLogExpirationSelect" 
                    name="new_value_eventLogExpirationSelect" 
                    size="1"
                    class="dropdown ui-corner-all editable">
                  
				<c:forEach var="selectOption" items="${eventLogExpirationOptionsMap}" varStatus="option">
				  <c:choose>
				    <c:when test="${option.index == eventLogSelectIndex}">
				      <option value="${selectOption.key}" selected="selected" class="ui-corner-all"><c:out value="${selectOption.value}"/></option>
				    </c:when>
				    <c:otherwise>
				      <option value="${selectOption.key}" class="ui-corner-all"><c:out value="${selectOption.value}"/></option>
				    </c:otherwise>
				  </c:choose>
				</c:forEach>
            </select>
          </div>
        </div>
        
        <div class="label-value-pair">
          <label>${res.EventLogMaxLogSize}</label>
             <div class="valueEntry">
               <input type="text"
                      id="new_value_eventLogSize"
                      name="new_value_eventLogSize"
                      minlength="0"
                      maxlength="4"
                      min="25"
                      max="2000"
                      size="4"
                      title="${res.EventLogSizeToolTip}"
                      class="textinput ui-corner-all required posint editable tooltip"
                      value="${eventLogSize}"/>
                      
                <div id="new_value_eventLogSize_unit" class="unit">${res.Events}</div>
             </div>
        </div>
        
        </div> <%-- h1 label-value-group ui-corner-all --%>
      
		<c:if test="${isSimpleSignaling eq false}">

			<h2>${res.DataLogConfigurationHeader}</h2>

			<div class="label-value-group ui-corner-all">
			
			<%-- This Log Warning is only displayed when log has greater than 60,963 entries --%>
			<c:if test="${displayDataLogPerformanceWarning eq true}">        
			<div class="label-value-pair">
			  <div class="valueEntry">
				<div id="displayDataLogPerformanceWarning" class="value">${res.LogSizeWarning}</div>
			  </div>
			</div>
			</c:if>
			
			<div class="label-value-pair">
			  <label for="new_value_dataloggingEnabledCheckBox">${res.EnableDataLogging}</label>
			  <div class="valueEntry">
				 <input type="checkbox"
						id="new_value_dataloggingEnabledCheckBox"
						name="new_value_dataloggingEnabledCheckBox"
						<c:if test="${dataLoggingEnabled}">checked="checked"</c:if>                    
						class="checkbox ui-corner-all jquerycheckbox editable"
						value="" />
			  </div>
			</div>
			
			<div class="label-value-pair">
			  <label>${res.DataLogExpiration}</label>
			  <div class="valueEntry">
				<select id="new_value_dataLogExpirationSelect" 
						name="new_value_dataLogExpirationSelect" 
						size="1"
						class="dropdown ui-corner-all editable">
					  
					<c:forEach var="selectOption" items="${dataLogExpirationOptionsMap}" varStatus="option">
					  <c:choose>
						<c:when test="${option.index == dataLogSelectIndex}">
						  <option value="${selectOption.key}" selected="selected" class="ui-corner-all"><c:out value="${selectOption.value}"/></option>
						</c:when>
						<c:otherwise>
						  <option value="${selectOption.key}" class="ui-corner-all"><c:out value="${selectOption.value}"/></option>
						</c:otherwise>
					  </c:choose>
					</c:forEach>
				</select>
			  </div>
			</div>
			
			<div class="label-value-pair">
			  <label>${res.RecordingInterval}</label>

			  <div id="new_value_dataLogRecordingInterval" class="valueEntry">
				  
				<span>
				<input type="text"
						id="new_value_dataLogRecordingIntervalMin"
						name="new_value_dataLogRecordingIntervalMin"
						maxlength="2"
						minlength="0"
						max="59" 
						min="0" 
						size="2" 
						title="${res.ZeroFiftyNineToolTip}"
						class="textinput ui-corner-all required posint editable tooltip datalogmins"
						value="${dataLogRecordingIntervalMin}"/>
				 </span>                     
				  
				<span class="unit">${res.MinsSecsSpacer}&nbsp;</span>       
				  
				<span>       
				<input type="text"
					   id="new_value_dataLogRecordingIntervalSec"
					   name="new_value_dataLogRecordingIntervalSec"
					   maxlength="2"
					   minlength="0"
					   max="59" 
					   min="0" 
					   size="2" 
					   title="${res.ZeroFiftyNineToolTip}"
					   class="textinput ui-corner-all required posint editable tooltip datalogsecsten datalogsecszero"
					   value="${dataLogRecordingIntervalSec}"/>
				</span>
				  
				<span class="paddedValueRight">&nbsp;&nbsp;${res.MinsSecsUnits}</span>       
			  </div>
			</div>
			
			</div> <%-- h2 label-value-group ui-corner-all --%>

		</c:if>
      
      </div> <%-- mainbox --%>
      
      <br/>
      <br/>
      
      <%-- Only include the hidden check-box vlaue if it was previously enabled --%>
      <c:if test="${eventLoggingEnabled eq true}">
        <input type="hidden" id="old_value_eventloggingEnabledCheckBox" name="old_value_eventloggingEnabledCheckBox" value="${eventLoggingEnabled}"  class="disabled"/>
      </c:if>
      <input type="hidden" id="old_value_eventLogExpirationSelect" name="old_value_eventLogExpirationSelect" value="${eventLogSelectValue}"  class="disabled"/>
      <input type="hidden" id="old_value_eventLogSize" name="old_value_eventLogSize" value="${eventLogSize}"  class="disabled"/>
      
      <%-- Only include the hidden check-box vlaue if it was previously enabled --%>
      <c:if test="${dataLoggingEnabled eq true}">
        <input type="hidden" id="old_value_dataloggingEnabledCheckBox" name="old_value_dataloggingEnabledCheckBox" value="${dataLoggingEnabled}"  class="disabled"/>
      </c:if>
      <input type="hidden" id="old_value_dataLogExpirationSelect" name="old_value_dataLogExpirationSelect" value="${dataLogSelectValue}"  class="disabled"/>
      <input type="hidden" id="old_value_dataLogRecordingInterval" name="old_value_dataLogRecordingInterval" value="${dataLogRecordingInterval}"  class="disabled"/>

      <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}"/>
      <input type="hidden" name="formtokenid" id="formtokenid" value="${formtokenid}"/>

      <div id="button-bar">
        <input type="submit" value="${res.ButtonApply}" class="button" id="apply" name="apply" disabled=""/>
      </div>
    </form>
  </main><%-- End of container --%>
  <div id="res">
    <span id="resNotANumberError">${res.NotANumberError}</span>
    <span id="resNotADecimalNumberError">${res.NotADecimalNumberError}</span>
    <span id="resMicroLinkInvalidAlphaNumCharacter"><c:out value="${res.MicroLinkInvalidAlphaNumCharacter}"/></span>   
    <span id="resMicroLinkInvalidUSASCIICharacter">${res.MicroLinkInvalidUSASCIICharacter}</span>
    <span id="resInvalidTimeFormat">${res.InvalidTimeFormat}</span>
    <span id="resInvalidMinsSecsFormat">${res.EventActionsCmdFileError}</span>
    <span id="resNavigateAwayMsg">${res.NavigateAwayMsg}</span>
    <span id="resErrorBoxMsg">${res.ErrorBoxMsg}</span>
    <span id="images"><img src="styles/cupertino/images/ui-icons_ffffff_256x240.png${version}"><img src="styles/cupertino/images/ui-icons_222222_256x240.png${version}"></span>
    <span id="resDataLogMinutesError">${res.DataLogMinutesError}</span>
    <span id="resDataLogSecondsErrorTen">${res.DataLogSecondsErrorTen}</span>
    <span id="resDataLogSecondsErrorZero">${res.DataLogSecondsErrorZero}</span>
    <span id="resLogSettingsZeroFiftyNineDynamicToolTip">${res.LogSettingsZeroFiftyNineDynamicToolTip}</span>
    <span id="resLogSettingsTenFiftyNineDynamicToolTip">${res.LogSettingsTenFiftyNineDynamicToolTip}</span>
  </div>
</body>
</html>