<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="pcssfn" uri="PCSSFunctions" %>
<html lang="${localeData.resourcesLocale}">
  <c:set var="res" value="${localeData.properties}"/>
  <c:set var="version" value="?${pcbeSettings.productVersion}"/>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="Expires" content="-1">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
    <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
    <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
    <link type="text/css" rel="stylesheet" href="/styles/outletstatus.min.css${version}">
    <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
    <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
    <script type="text/javascript" src="/js/common.js${version}"></script>
    <script type="text/javascript" src="/js/outletcmd.js${version}"></script>
    <title>${page.title}</title>
  </head>
  <body>
    <%@ include file="banner.jspf" %>
    <%@ include file="menu.jspf" %>
    <c:set var="target" value="${outletSystem.allOutletGroups[submitindex]}"/>
    <main id="contentcontainer">
      <h1 id="pageHeader">${page.header}</h1>
      <div id="mainbox">
        <h2>${res.ConfirmationBoxTitle}</h2>
        <form id="outletcmdform" action="<c:url value='${page.action}'/>" name="${page.name}" method="post">
          <div id="outletstatus">
            <div class="label-value-pair">
              <c:if test="${target.pcbeOutlet}">
                <div class="serverimg">
                  <img src="/images/pcbeserver.png${version}"/>
                </div>
              </c:if>
              <label>
                <c:out value="${not empty target.outletName ? target.outletName : target.outletLabel}"/>
              </label>
              <div class="value"><c:out value="${res[submitcmd]}"/></div>
            </div>
            <c:forEach var="cmd" items="${outletcmds}" varStatus="vs">
              <c:if test="${cmd.name == submitcmd}">
                <c:if test="${cmd.onDelay}">
                  <div class="msgtext">
                    <c:out value="${pcssfn:format1(res.OnDelayMsg, target.turnOnCountdownSetting)}"/>
                  </div>
                </c:if>
                <c:if test="${cmd.onImmediately}">
                  <div class="msgtext">
                    <c:out value="${res.OnImmediatelyMsg}"/>
                  </div>
                </c:if>
                <c:if test="${cmd.offDelay}">
                  <div class="msgtext">
                    <c:choose>
                      <c:when test="${target.pcbeOutlet}">
                        <c:out value="${pcssfn:format1(res.OffDelayMsg, osShutdown.OSShutdownDelay + target.turnOffCountdownSetting)}"/>
                      </c:when>
                      <c:otherwise>
                        <c:out value="${pcssfn:format1(res.OffDelayMsg, target.turnOffCountdownSetting)}"/>
                      </c:otherwise>
                    </c:choose>
                  </div>
                </c:if>
                <c:if test="${cmd.offImmediately}">
                  <div class="msgtext">
                    <c:out value="${res.OffImmediatelyMsg}"/>
                  </div>
                </c:if>
                <c:if test="${cmd.shutdownDelay || cmd.rebootDelay}">
                  <div class="msgtext">
                    <c:choose>
                      <c:when test="${target.pcbeOutlet}">
                        <c:out value="${pcssfn:format2(res.ShutdownDelayMsg, osShutdown.OSShutdownDelay + target.turnOffCountdownSetting, target.stayOffCountdownSetting + target.turnOnCountdownSetting)}"/>
                      </c:when>
                      <c:otherwise>
                        <c:out value="${pcssfn:format2(res.ShutdownDelayMsg, target.turnOffCountdownSetting, target.stayOffCountdownSetting + target.turnOnCountdownSetting)}"/>
                      </c:otherwise>
                    </c:choose>
                  </div>
                </c:if>
                <c:if test="${cmd.shutdownImmediately || cmd.rebootImmediately}">
                  <div class="msgtext">
                    <c:out value="${pcssfn:format1(res.ShutdownImmediatelyMsg, target.stayOffCountdownSetting + target.turnOnCountdownSetting)}"/>
                  </div>
                </c:if>
                <c:if test="${cmd.cancelCommand}">
                  <div class="msgtext">
                    <c:out value="${res.CancelCommandMsg}"/>
                  </div>
                </c:if>
                <c:if test="${target.pcbeOutlet}">
                  <c:if test="${cmd.offImmediately || cmd.shutdownImmediately || cmd.rebootImmediately}">
                    <div class="ui-corner-all warningbox"> 
                      <div>
                        <span class="warningimg"></span>
                        <c:out value="${res.PCBEServerTurnOffWarningMsg}"/>
                      </div>
                    </div>
                  </c:if>
                </c:if>
              </c:if>
            </c:forEach>
            <div id="submitbox">
              <input type="submit" name="apply" id="apply" class="button" value="${res.ButtonConfirm}"/>
              <input type="submit" name="cancel" id="cancel" class="button" value="${res.ButtonCancel}"/>
            </div>
          </div>
          
          <input type="hidden" name="submit${submitindex}" value="${submitindex}"/>
          <input type="hidden" name="outletcmd${submitindex}" value="${submitcmd}"/>
          <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}"/>
          <input type="hidden" name="formtokenid" id="formtokenid" value="${formtokenid}"/>
        </form>
      </div>
    </main>
  </body>
</html>