<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="pcssfn" uri="PCSSFunctions" %>
<html lang="${localeData.resourcesLocale}">
  <c:set var="res" value="${localeData.properties}"/>
  <c:set var="version" value="?${pcbeSettings.productVersion}"/>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="Expires" content="-1">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
    <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
    <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
    <link type="text/css" rel="stylesheet" href="/styles/outletstatus.min.css${version}">
    <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
    <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
    <script type="text/javascript" src="/js/common.js${version}"></script>
    <script type="text/javascript" src="/js/outletctrl.js${version}"></script>
    <title>${page.title}</title>
  </head>
  <body>
    <%@ include file="banner.jspf" %>
    <%@ include file="menu.jspf" %>
    <c:set var="sogs" value="${outletSystem.allOutletGroups}" />
    <main id="contentcontainer">
      <h1 id="pageHeader">${page.header}</h1>

      <div id="errorcontainer" class="ui-corner-all ${errorState ? 'showError' : ''}">
        <c:if test="${errorState}">
          <c:set var ="sog" value="${sogs[submitindex]}"/>
          <c:set var="name" value="${not empty sog.outletName ? sog.outletName : sog.outletLabel}"/>
          <c:out value="${pcssfn:format2(res['OutletControl.errorMsg1'], res[submitcmd], name)}"/><br/>
          <c:out value="${res['OutletControl.errorMsg2']}"/>
        </c:if>
      </div>

      <div id="outletstatus">
        <form id="outletctrlform" action="<c:url value='${page.action}'/>" name="${page.name}" method="post">
          <div id="columns" class="ui-corner-top">
            <div id="servercolumn" class="column">&nbsp;</div>
            <div id="outletcolumn" class="column">${res.OutletColumnHeader}</div>
            <div id="statuscolumn" class="column">${res.StatusColumnHeader}</div>
            <div id="actioncolumn" class="column">${res.ActionColumnHeader}</div>
          </div>
          <c:set var="hasmog" value="${sogs[0].mainOutlet}" />
          <div class="label-value-group ui-corner-bottom">
            <c:forEach var="sog" items="${sogs}" varStatus="vs">
              <div class="${vs.first && hasmog ? 'mog ' : ''} label-value-pair">
                <div class="serverimg">
                  <c:if test="${sog.pcbeOutlet}">
                    <img src="/images/pcbeserver.png${version}"/>
                  </c:if>
                </div>
                <label>
                  <c:out value="${not empty sog.outletName ? sog.outletName : sog.outletLabel}"/>
                </label>
                <div id="status${vs.index}" class="value">
                  <c:forEach var="outletStatus" items="${sog.describedOutletStatus}" varStatus="vs1">
                    <c:out value="${res[outletStatus]}"/>
                    <c:if test="${not vs1.last}">,&nbsp;</c:if>
                  </c:forEach>
                </div>
                <c:set var="sogcmd" value="${sogcmds[vs.index]}"></c:set>
                <select name="outletcmd${vs.index}" size="1" class="dropdown ui-corner-all editable ${errorState && vs.index == submitindex ? ', error' : ''}">
                  <c:forEach var="cmd" items="${sogcmd}" varStatus="vs2">
                    <c:if test="${vs2.first}">
                      <option selected="selected" value="${cmd.name}">${res[cmd.name]}</option>
                    </c:if>
                    <c:if test="${not vs2.first}">
                      <option value="${cmd.name}">${res[cmd.name]}</option>
                    </c:if>
                  </c:forEach>
                </select>
                <input type="submit" id="apply-button" class="button" name="submit${vs.index}" value="${res.ButtonApply}"/>
              </div>
            </c:forEach>
          </div>
          <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}"/>
          <input type="hidden" name="formtokenid" id="formtokenid" value="${formtokenid}"/>
        </form>
        <c:if test="${isUPSLink}">
	        <div class="msgtext">
	        	${res.UPSLinkImmediatelyMsg}
	        </div>
        </c:if>
      </div>
    </main>
  </body>
</html>