<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="pcssfn" uri="PCSSFunctions"%>
<html lang="${localeData.resourcesLocale}">
<c:set var="res" value="${localeData.properties}" />
<c:set var="version" value="?${pcbeSettings.productVersion}"/>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="Expires" content="-1">
  <meta http-equiv="Pragma" content="no-cache">
  <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
  <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
  <link type="text/css" rel="stylesheet" href="/styles/jquery.cluetip.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/fullcalendar.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
  <c:if test="${wizard}"><link type="text/css" rel="stylesheet" href="/styles/shutdownwizard.min.css${version}"></c:if>
  <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
  <script type="text/javascript" src="/js/jquery.cluetip.js${version}"></script>
  <script type="text/javascript" src="/js/jquery.validate.min.js${version}"></script>
  <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>  
  <script type="text/javascript" src="/js/jquery.timeentry.js${version}"></script>
  <script type="text/javascript" src="/js/common.js${version}"></script>
  <script type="text/javascript" src="/js/fullcalendar.js${version}"></script>
  <c:if test="${isUPSLink}">
  	<script type="text/javascript" src="/js/scheduledShutdownUPSLink.js${version}"></script>
  </c:if>
  <c:if test="${!isUPSLink}">
  	<script type="text/javascript" src="/js/scheduledShutdown.js${version}"></script>
  </c:if>
  <c:if test="${wizard}"><script type="text/javascript" src="/js/shutdownwizard.js${version}"></script></c:if>
  <c:forEach var="jssrc" items="${page.scriptSource}">
    <script type="text/javascript" src="${jssrc}${version}"></script>
  </c:forEach>
  <title>${page.title}</title>
</head>
<body>
  <%@ include file="banner.jspf" %>
  <%@ include file="menu.jspf" %>
  <%@ include file="shutdownwizardmenu.jspf" %>
  <main id="contentcontainer">
    <h1 id="pageHeader">${page.header}</h1>
    
		    <form id="formpageform" action="<c:url value='${page.action}'/>" name="${page.name}" method="post">
		      <%-- holds device drop down --%>
		      <div id="mainbox">
		      
			      <div id="value_CalendarText" class="label-value-pair emphasis">${res.ScheduleShutdownCalendarText}</div>
			      
			      <div id="shutdowncalendar" class="calendar"></div>
			        
		          <div title="${res.ScheduleShutdownDialogTitle}" class="calendarDialog hidden">
		          
		              <%-- holds error message warning --%>
		                <div class="ui-corner-all" id="errorcontainer">
					        ${res.ErrorDialogBoxMsg}
					    </div>
		          
			          <div class="label-value-pair">
			            <label for="new_value_ShutdownName">${res.ScheduleShutdownName}</label>
			              <div class="valueEntry">                
			                    <input type="text"
			                      id="new_value_ShutdownName"
			                      name="new_value_ShutdownName"
			                      maxlength="${ScheduleNameLength}"
			                      minlength="0"
			                      size="50"
			                      class="textinput xss ui-corner-all editable validateShutdownName required"
			                      value="" />                  
			              </div>            
			          </div>
			            
			          <div class="label-value-pair">
			            <label for="value_ScheduleFromDate">${res.ScheduleNewScheduleStartDate}</label>
			              <div class="valueEntry">  
			                   <span>              
			                    <input type="text"
			                      id="value_ScheduleFromDate"
			                      name="value_ScheduleFromDate"
			                      maxlength="${DatePickerLength}"
			                      minlength="0"
			                      size="${DatePickerLength}"
			                      class="ui-corner-all datepicker textinput required editable"
			                      value=""
			                      disabled="disabled"/>  
			                   </span>  
			                   <span class="paddedValueRight">
			                   </span>
			                   <span>
				                   <c:if test="${isUPSLink}">
					                   <select id="value_ScheduleFromHour" 
										  name="value_ScheduleFromHour" 
										  size="1"
										  class="dropdown ui-corner-all editable">
											<c:forEach var="fromHour" begin="0" end="23" step="1">
												<option value="${fromHour}">${fromHour}</option>
											</c:forEach>
										</select>
										<span class="unit">
		                           			${res.MinsSecsSpacer}
		                   				</span>
					                   <select id="value_ScheduleFromMin" 
										  name="value_ScheduleFromMin" 
										  size="1"
										  class="dropdown ui-corner-all editable validateDateBeforeNow">
											<c:forEach var="fromMin" begin="0" end="59" step="1">
												<option value="${fromMin}">${fromMin}</option>
											</c:forEach>
										</select>
										<span class="paddedValueRight">
		                           			${res.HoursMinutesShort}
		                   				</span>
				                   </c:if>
				                   <c:if test="${!isUPSLink}">
				                        <input type="text"
				                          id="value_ScheduleFromTime"
				                          name="value_ScheduleFromTime"
				                          maxlength="${TimePickerLength}"
				                          minlength="0"
				                          size="${TimePickerLength}"
				                          class="ui-corner-all textinput required editable validateDateBeforeNow"
				                          value=""/>
									</c:if>
		                        </span>  
			              </div>        
			          </div>
			          
				      <div class="label-value-pair">
			            <label for="value_ScheduleToDate">${res.ScheduleNewScheduleEndDate}</label>
			              <div class="valueEntry">
			               <span>
			                   <input type="text"
		                          id="value_ScheduleToDate"
		                          name="value_ScheduleToDate"
		                          maxlength="${DatePickerLength}"
		                          minlength="0"
		                          size="${DatePickerLength}"
		                          class="ui-corner-all datepicker textinput required editable"
		                          readonly="readonly"
		                          value=""/>
			               </span>
			               <span class="paddedValueRight">
		                   </span>
			               <span>
				               <c:if test="${isUPSLink}">
				               		<select id="value_ScheduleToHour" 
									  name="value_ScheduleToHour" 
									  size="1"
									  class="dropdown ui-corner-all editable">
										<c:forEach var="toHour" begin="0" end="23" step="1">
											<option value="${toHour}">${toHour}</option>
										</c:forEach>
									</select>
									<span class="unit">
		                           		${res.MinsSecsSpacer}
		                   			</span>
				                   <select id="value_ScheduleToMin" 
									  name="value_ScheduleToMin" 
									  size="1"
									  class="dropdown ui-corner-all editable validateShutdownDuration">
										<c:forEach var="toMin" begin="0" end="59" step="1">
											<option value="${toMin}">${toMin}</option>
										</c:forEach>
									</select>
									<span class="paddedValueRight">
		                           		${res.HoursMinutesShort}
		                   			</span>
								</c:if>
								<c:if test="${!isUPSLink}">
				                   <input type="text"
			                          id="value_ScheduleToTime"
			                          name="value_ScheduleToTime"
			                          maxlength="${TimePickerLength}"
			                          minlength="0"
			                          size="${TimePickerLength}"
			                          class="ui-corner-all required editable textinput validateShutdownDuration"
			                          value=""/>
								</c:if>
			               </span>
			              </div> 
			          </div>
			          
		              <div class="divgroupSmallMargin ui-corner-all">
		                  <div class="label-value-pair emphasis">${res.SchedulePeriodText}</div>
		                  <div class="label-value-pair">
		                    <label for="new_value_periodOnce">${res.PeriodOnce}</label>
		                      <div class="valueEntry">
		                            <input type="radio"
		                              id="new_value_periodOnce"
		                              name="value_periodRadioButtonGroup"
		                              class="radio ui-corner-all editable"
		                              value="${PeriodOnce}" />
		                      </div>
		                  </div>
		        
		                  <div class="label-value-pair">
		                    <label for="new_value_periodDaily">${res.PeriodDaily}</label>
		                      <div class="valueEntry">
		                            <input type="radio"
		                              id="new_value_periodDaily"
		                              name="value_periodRadioButtonGroup"
		                              class="radio ui-corner-all editable"
		                              value="${PeriodDaily}" />
		                      </div>
		                  </div>
		        
		                  <div class="label-value-pair">
		                    <label for="new_value_periodWeekly">${res.PeriodWeekly}</label>
		                      <div class="valueEntry">
		                            <input type="radio"
		                              id="new_value_periodWeekly"
		                              name="value_periodRadioButtonGroup"
		                              class="radio ui-corner-all editable"
		                              value="${PeriodWeekly}" />
		                      </div>
		                  </div>
		              </div>
		
			          <div class="divgroupSmallMargin ui-corner-all">
			          
			               <div id="value_OutletGroupText" class="label-value-pair emphasis">${res.ScheduleOutletGroupsText}</div>
			               
			               <%-- loop thru all OutletGroupData label value pairs for this page --%>
					       <c:forEach var="lvp" items="${OutletGroupData}" varStatus="vs">
					             <div class="label-value-pair">
					                <%-- display label icon if there is one --%>
						            <img class="labelicon" title="${res.PCBEOG}" src="${lvp.labelIcon}${version}" alt="${res.PCBEOGTitle}">
						            
						            <%-- display label --%>
						            <label for="${lvp.linkedValueId}" class="iconwidth">${lvp.label}</label>
						            
						            <c:forEach var="lvpvalue" items="${lvp.values}">
		                               <div class="valueEntry">
		                                   <input type="checkbox"
						                      id="${lvpvalue.id}"
						                      name="${lvpvalue.name}"
						                      class="checkbox ui-corner-all <c:if test="${not empty lvpvalue.cssClasses}">${lvpvalue.cssClassesAsString}</c:if>"
						                      value="<c:out value="${lvpvalue.value}"/>" />
		                               </div>
			                        </c:forEach>				            
					             </div>			        
					      </c:forEach>
					
				          <div id="value_MOGText" class="label-value-pair">
			                 <img class="labelicon" src="/images/warning.png${version}" alt="${res.SeverityWarning}">
			                 <div class="warning">${res.ScheduleShutdownMOGText}</div>
				          </div>
				          
				          <div id="value_PCBEOGText" class="label-value-pair">
			                 <img class="labelicon" src="/images/warning.png${version}" alt="${res.SeverityWarning}">
			                 <div class="warning">${res.ScheduleShutdownPCBEOGText}</div>
				          </div>
			          
			          </div><%-- end of outlet group wrapper div --%>
		
		              <div class="label-value-pair">${res.ScheduleTimeZoneText} ${agentTimeZone}</div>
		
		          </div><%-- end of dialog div --%>
		            
		      </div>

			  <a href="${dialogHelp}" id="dialogHelpLink" class="ui-dialog-titlebar-close ui-corner-all" role="button" target="_blank"><span class="ui-icon ui-icon-help">help</span></a>
		
		      <c:forEach var="hidden" items="${page.hiddenInputs}">
		        <input type="hidden" id="${hidden.id}" name="${hidden.name}" value="<c:out value="${hidden.value}"/>" <c:if test="${not empty hidden.cssClasses}"> class="${hidden.cssClassesAsString}"</c:if>/>
		      </c:forEach>
		      <input id="cancelledSchedule" type="hidden" value="" name="cancelledSchedule">
		      <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}"/>
		      <input type="hidden" name="formtokenid" id="formtokenid" value="${formtokenid}"/>
		      <%@ include file="button.jspf" %>
		      <%@ include file="shutdownwizardbutton.jspf" %>
		    </form>
		    <div id="submitdialog" title="${res.SubmitDialogTitle}">
			    <p>${res.SubmitDialogContent}</p>
			    <p class="waitimg"><img src="/styles/images/wait.gif${version}" alt="${res.sProcessing}"/></p>
			</div>
   
  </main><%-- End of container --%>
  <div id="res">     
    <span id="resNavigateAwayMsg">${res.NavigateAwayMsg}</span>
    <span id="resWarningScheduleOverlap">${res.WarningOverlap}</span>
    <span id="resWarningInvalidOverlap">${res.WarningInvalidOverlap}</span>
    <span id="resWarningInvalidMinDuration">${res.WarningInvalidMinDuration}</span>
    <span id="resWarningInvalidTargetedOutlets">${res.WarningInvalidTargetedOutlets}</span>
    <span id="resWarningInvalidCheckRedBorder">${res.WarningInvalidCheckRedBorder}</span>
    <span id="resConfirmScheduleDelete">${res.ConfirmDelete}</span>
    <span id="resConfirmMaxRecommendedSchedules">${res.ConfirmMaxRecommendedSchedules}</span>
    <span id="resErrorBoxMsg">${res.ErrorBoxMsg}</span>
    <span id="resErrorCrossSiteScripting">${res.ErrorCrossSiteScripting}</span>
    <span id="resErrorScheduleNoOutletGroups">${res.ErrorNoOutletGroups}</span>
    <span id="resErrorDefaultMinShutdownDuration">${res.ErrorDefaultMinShutdownDuration}</span>
    <span id="resErrorDateBeforeNow">${res.ErrorDateBeforeNow}</span>  
    <span id="resErrorPastDate">${res.ErrorPastDate}</span>  
    <span id="resErrorScheduleObsolete">${res.ErrorScheduleObsolete}</span>     
    <span id="resErrorShutdownName">${res.ErrorShutdownName}</span>
    <span id="resErrorNewSchedulePCBEOff">${res.ErrorNewSchedulePCBEOff}</span>
    <span id="resErrorExistingSchedulePCBEOff">${res.ErrorExistingSchedulePCBEOff}</span>
    <span id="resErrorPendingShutdown">${res.ErrorPendingShutdown}</span> 
    <span id="resErrorIdenticalPeriod">${res.ErrorIdenticalPeriod}</span>  
    <span id="resErrorIdenticalStartTimes">${res.ErrorIdenticalStartTimes}</span>   
    <span id="resErrorShutdownDurationOnce">${res.ErrorShutdownDurationOnce}</span>  
    <span id="resErrorShutdownDurationDaily">${res.ErrorShutdownDurationDaily}</span>  
    <span id="resErrorShutdownDurationWeekly">${res.ErrorShutdownDurationWeekly}</span>    
    <span id="resErrorSOG1MinDuration">${pcssfn:format1( res.ErrorMinShutdownDuration, sog1MinDuration )}</span>
    <span id="resErrorSOG2MinDuration">${pcssfn:format1( res.ErrorMinShutdownDuration, sog2MinDuration )}</span>
    <span id="resErrorSOG3MinDuration">${pcssfn:format1( res.ErrorMinShutdownDuration, sog3MinDuration )}</span>
    <span id="resErrorMOGMinDurationApp">${pcssfn:format1( res.ErrorMinShutdownDuration, mogMinDurationApp )}</span>
    <span id="resErrorSOG1MinDurationApp">${pcssfn:format1( res.ErrorMinShutdownDuration, sog1MinDurationApp )}</span>
    <span id="resErrorSOG2MinDurationApp">${pcssfn:format1( res.ErrorMinShutdownDuration, sog2MinDurationApp)}</span>
    <span id="resErrorSOG3MinDurationApp">${pcssfn:format1( res.ErrorMinShutdownDuration, sog3MinDurationApp )}</span>
    <span id="sog1MinDuration">${sog1MinDuration}</span>
    <span id="sog2MinDuration">${sog2MinDuration}</span>
    <span id="sog3MinDuration">${sog3MinDuration}</span>
    <span id="mogMinDurationApp">${mogMinDurationApp}</span>
    <span id="sog1MinDurationApp">${sog1MinDurationApp}</span>
    <span id="sog2MinDurationApp">${sog2MinDurationApp}</span>
    <span id="sog3MinDurationApp">${sog3MinDurationApp}</span>
    <span id="agentUTCOffset">${agentUTCOffset}</span>
    <span id="outletGroupIndices">${OutletGroupIndices}</span>
    <span id="resMessageDialogWarningTitle">${res.MessageDialogWarningTitle}</span>
    <span id="resMessageDialogConfirmationTitle">${res.MessageDialogConfirmationTitle}</span>
    <span id="resYes">${res.Yes}</span>
    <span id="resNo">${res.No}</span>
    <span id="resConfirmCancelShutdownTitle">${res.ConfirmCancelShutdownTitle}</span>
    <span id="resConfirmCancelMessageSD">${res.ConfirmCancelMessageSD}</span>
    <span id="resShutdownInProgressText">${res.ShutdownInProgressText}</span>   
    <span id="images"><img src="/styles/cupertino/images/ui-icons_ffffff_256x240.png${version}" alt="${res.AltTextIcons}"/><img src="/styles/cupertino/images/ui-icons_222222_256x240.png${version}" alt="${res.AltTextIcons}"/></span>
  </div>
</body>
</html>