<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<html lang="${localeData.resourcesLocale}">
<c:set var="res" value="${localeData.properties}" />
<c:set var="version" value="?${pcbeSettings.productVersion}"/>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="Expires" content="-1">
  <meta http-equiv="Pragma" content="no-cache">
  <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
  <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
  <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/status.min.css${version}">
  <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
  <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
  <script type="text/javascript" src="/js/common.js${version}"></script>
  
  
  
  
  
  <title>${page.title}</title>
</head>
<body>
  <%@ include file="banner.jspf" %>
  <%@ include file="menu.jspf" %>
  

  
  <main id="contentcontainer">
  

    <h1 id="pageHeader">${page.header}</h1>
    <div id="mainbox">
  
      <c:forEach var="lvp" items="${page.labelValuePairs}" varStatus="vs">
        <c:if test="${not empty lvp.subHeader}">
          <c:if test="${not vs.first}"></div></c:if>
          <h2<c:if test="${not empty lvp.cssClasses}"> class="${lvp.cssClassesAsString}"</c:if>>${lvp.subHeader}</h2>
          <div class="label-value-group ui-corner-all">
        </c:if>
        
        <%-- lvps can be wrapped inside a div by adding a start div id to the first lvp inside, and an end div to the last --%>
        <c:if test="${not empty lvp.startDivGroupClasses}"> <div <c:if test="${not empty lvp.startDivGroupTitle}">title="${lvp.startDivGroupTitle}"</c:if> class="${lvp.startDivGroupClasses}"></c:if>
        
        <div class="label-value-pair"<c:if test="${not empty lvp.id}"> id="${lvp.id}"</c:if>>
          <label>${lvp.label}</label>
          <c:forEach var="stringvalue" items="${lvp.values}">
          	<c:choose>
  				<c:when test="${not empty stringvalue.id && stringvalue.id == 'autoUpdateId'}">
    				<div class="value ${stringvalue.cssClassesAsString}" id="${stringvalue.id}"> ${stringvalue.value}</div>
  				</c:when>
  				<c:otherwise>
					<div class="value" id="${stringvalue.id}"><c:out value="${stringvalue.value}"/> </div>
					<c:if test="${not empty stringvalue.unit}"><div class="unit">${stringvalue.unit}</div></c:if>
				</c:otherwise>
			</c:choose>
          </c:forEach>
        </div>
        
        <%-- lvps can be wrapped inside a div by adding a start div id to the first lvp inside, and an end div to the last --%>
        <c:if test="${lvp.endDivGroup}"></div></c:if>
        
        <c:if test="${vs.last}"></div></c:if>
      </c:forEach>

      <%-- outtlet status --%>
      <c:if test="${showoutletstatus}">
        <c:set var="sogs" value="${outletSystem.allOutletGroups}" />
        <h2 class="expandable minimized">${res.headerOutletStatus}</h2>
        <div id="outletstatus">
          <div id="columns" class="ui-corner-top">
            <div id="servercolumn" class="column">&nbsp;</div>
            <div id="outletcolumn" class="column">${res.OutletColumnHeader}</div>
            <div id="statuscolumn" class="column">${res.StatusColumnHeader}</div>
          </div>
          <c:set var="hasmog" value="${sogs[0].mainOutlet}" />
          <div class="label-value-group ui-corner-bottom">
            <c:forEach var="sog" items="${sogs}" varStatus="vs">
              <div class="${vs.first && hasmog ? 'mog ' : ''} label-value-pair">
                <div class="serverimg">
                  <c:if test="${sog.pcbeOutlet}">
                    <img src="/images/pcbeserver_medium.png${version}"/>
                  </c:if>
                </div>
                <label>
                  <c:out value="${not empty sog.outletName ? sog.outletName : sog.outletLabel}"/>
                </label>
                <div id="status${vs.index}" class="value">
                  <c:forEach var="outletStatus" items="${sog.describedOutletStatus}" varStatus="vs1">
                    <c:out value="${res[outletStatus]}"/>
                    <c:if test="${not vs1.last}">,&nbsp;</c:if>
                  </c:forEach>
                </div>
              </div>
            </c:forEach>
          </div>
        </div>
      </c:if>


  


	
	</div>
  </main>
  <div id="res">
    <span id="images"><img src="styles/cupertino/images/ui-icons_ffffff_256x240.png${version}"><img src="styles/cupertino/images/ui-icons_222222_256x240.png${version}"></span>
  </div>
</body>
</html>